package ru.yandex.ps.webtools.aceventura;

import java.io.IOException;

import org.apache.http.HttpHost;

import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.search.web.DefaultPsProject;
import ru.yandex.mail.search.web.WebApi;
import ru.yandex.mail.search.web.health.base.PsProjectType;

public class AceventuraProject extends DefaultPsProject {
    private final AsyncClient msalClient;
    private final AsyncClient searchClient;
    private final HttpHost msalHost;

    public AceventuraProject(
        final WebApi webApi,
        final PsProjectType project,
        final ImmutableAceventuraProjectConfig config)
        throws IOException
    {
        super(webApi, project, config);

        this.msalHost = config.msalConfig().host();
        this.msalClient =
            webApi.client(config.projectId() + "-Msal", config.msalConfig());
        this.searchClient = webApi.client(config.projectId() + "-SearchClient", config.searchConfig());

        webApi.register(config, "/check/index/fast", new FastCheckIndexHandler(this));
        webApi.register(config, "/check/index/full", new FullCheckIndexHandler(this));
    }

    public AsyncClient msalClient() {
        return msalClient;
    }

    public HttpHost msalHost() {
        return msalHost;
    }

    @Override
    public AsyncClient searchClient() {
        return searchClient;
    }
}
