package ru.yandex.ps.webtools.aceventura;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AceventuraProjectConfigBuilder
     extends AbstractAceventuraProjectConfigBuilder<AceventuraProjectConfigBuilder>
{
    public AceventuraProjectConfigBuilder() {
        this(AceventuraProjectConfigDefaults.INSTANCE);
    }

    public AceventuraProjectConfigBuilder(final AceventuraProjectConfig config) {
        super(config);
    }

    public AceventuraProjectConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AceventuraProjectConfigDefaults.INSTANCE);
    }

    public AceventuraProjectConfigBuilder(
        final IniConfig config,
        final AceventuraProjectConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAceventuraProjectConfig build() throws ConfigException {
        return new ImmutableAceventuraProjectConfig(
            this);
    }

    @Override
    public AceventuraProjectConfigBuilder self() {
        return this;
    }
}
