package ru.yandex.ps.webtools.common;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.mail.search.web.health.HealthCheckService;
import ru.yandex.mail.search.web.health.base.ProjectQueue;
import ru.yandex.mail.search.web.health.base.Shard;
import ru.yandex.mail.search.web.health.base.ShardReplica;
import ru.yandex.ps.webtools.mail.MailSearchProject;

public abstract class AbstractPeachHandler implements ProxyRequestHandler {
    protected final MailSearchProject project;
    protected final HealthCheckService health;

    public AbstractPeachHandler(
        final MailSearchProject project,
        final HealthCheckService health)
    {
        this.project = project;
        this.health = health;
    }

    protected abstract void handle(
        final ProxySession session,
        final ShardReplica replica)
        throws HttpException, IOException;

    protected Set<String> services(
        final ProxySession session)
        throws HttpException, IOException
    {
        return Collections.singleton(project.defaultService());
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        String hostname = session.params().getString("host");
        int shardNum = session.params().getInt("shard");

        Set<ShardReplica> replicas = new LinkedHashSet<>();

        for (String service: services(session)) {
            ProjectQueue queue = health.projectRoot().queue(service);
            if (queue == null) {
                continue;
            }

            Shard shard = queue.shard(shardNum);
            if (shard == null) {
                continue;
            }

            ShardReplica replica = shard.replica(hostname);
            if (replica == null) {
                continue;
            }

            replicas.add(replica);
        }

        if (replicas.size() != 1) {
            throw new BadRequestException(
                "No replicas or more than 1 found for config "
                    + " queues " + services(session)
                    + " host " + hostname);
        }

        ShardReplica replica = replicas.iterator().next();
        handle(session, replica);
    }
}
