package ru.yandex.ps.webtools.common;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.search.web.health.HealthCheckService;
import ru.yandex.mail.search.web.health.base.ShardReplica;
import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.ps.webtools.mail.MailSearchProject;

public class DropPeachRecordsHandler extends AbstractPeachHandler {
    private static final String FIELD = "peach_sequence:[";
    private static final String OR = "+OR+";

    public DropPeachRecordsHandler(
        final MailSearchProject project,
        final HealthCheckService health)
    {
        super(project, health);
    }

    @Override
    protected void handle(
        final ProxySession session,
        final ShardReplica replica)
        throws HttpException, IOException
    {
        List<String> ranges = session.params().getAll("range");
        //by ranges
        if (ranges.isEmpty()) {
            throw new BadRequestException("No ranges supplied");
        }

        StringBuilder sb = new StringBuilder("/delete?peach&webtools&prefix=");
        sb.append(replica.shard().id());
        sb.append("&text=");
        for (String range: ranges) {
            String[] split = range.split("-");
            int start;
            int end;

            try {
                start = PositiveIntegerValidator.INSTANCE.apply(split[0].trim());
                end = PositiveIntegerValidator.INSTANCE.apply(split[1].trim());
            } catch (Exception e) {
                throw new BadRequestException("Failed to parse range " + range);
            }

            if (start > end) {
                throw new BadRequestException("Invalid range " + range);
            }

            sb.append(FIELD);
            sb.append(start);
            sb.append("+TO+");
            sb.append(end);
            sb.append(']');
            sb.append(OR);
        }

        sb.setLength(sb.length() - OR.length());

        session.logger().info("Delete uri " + sb.toString());
        AsyncClient client = project.searchClient().adjust(session.context());
        client.execute(
            new HttpHost(replica.host().hostname(),replica.host().indexerPort()),
            new BasicAsyncRequestProducerGenerator(sb.toString()),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            session.listener().createContextGeneratorFor(client),
            new DeleteCallback(session));
    }

    private static class DeleteCallback extends AbstractProxySessionCallback<Object> {
        public DeleteCallback(ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
