package ru.yandex.ps.webtools.common.peach;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class BrokenRecordsRange implements JsonValue {
    private long peachSeqStart = -1;
    private long peachSeqEnd = -1;
    private boolean ubounded = false;

    public BrokenRecordsRange(final long peachSeqStart) {
        this.peachSeqStart = peachSeqStart;
        this.peachSeqEnd = peachSeqStart;
    }

    public void end(final int end) {
        this.peachSeqEnd = end;
    }

    public BrokenRecordsRange ubounded(final boolean ubounded) {
        this.ubounded = ubounded;
        return this;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("start");
        writer.value(peachSeqStart);
        writer.key("end");
        writer.value(peachSeqEnd);
        writer.key("unbounded");
        writer.value(ubounded);
        writer.endObject();
    }
}
