package ru.yandex.ps.webtools.common.peach;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.writer.JsonType;

public final class FindAllInvalidConsumer
    implements PeachRecordCheckConsumer
{
    private final ProxySession session;
    private final List<BrokenRecordsRange> intervals;
    private final Set<String> errors;
    private final FutureCallback<PeachShardValidateReport> callback;
    private final long shard;
    private BrokenRecordsRange broken;
    private int state = 0;

    public FindAllInvalidConsumer(
        final ProxySession session,
        final long shard,
        final FutureCallback<PeachShardValidateReport> callback)
    {
        this.session = session;

        this.errors = new LinkedHashSet<>();
        this.intervals = new ArrayList<>();
        this.callback = callback;
        this.shard = shard;
    }

    @Override
    public synchronized boolean valid(final JsonMap item, final long peachSeq) {
        if (state == 1) {
            state = 0;
            broken = null;
        }

        return true;
    }

    @Override
    public synchronized boolean invalid(
        final JsonMap item,
        final long peachSeq,
        final String error)
    {
        String errorRecord = "Invalid record " + error + " " + JsonType.NORMAL.toString(item);
        if (errors.size() <= 10) {
            errors.add(errorRecord);
            session.logger().warning(errorRecord);
        }

        if (state == 0) {
            broken = new BrokenRecordsRange(peachSeq);
            intervals.add(broken);
            state = 1;
        }

        return true;
    }

    @Override
    public synchronized void exhausted() {
        if (state == 1) {
            broken.ubounded(true);
        }

        callback.completed(new PeachShardValidateReport(shard, errors, intervals, intervals.size() > 0));
    }
}
