package ru.yandex.ps.webtools.common.peach;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class MultiShardValidationPrinter
    extends AbstractProxySessionCallback<List<PeachShardValidateReport>>
{
    private final PeachRequestContext context;
    private final JsonType jsonType;
    private final boolean errorsOnly;

    public MultiShardValidationPrinter(
        final PeachRequestContext context)
        throws BadRequestException
    {
        super(context.session());

        this.context = context;
        this.jsonType = JsonTypeExtractor.NORMAL.extract(context.session().params());
        this.errorsOnly = context.session().params().getBoolean("only-errors", false);
    }

    @Override
    public void completed(final List<PeachShardValidateReport> result) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter jw = JsonType.NORMAL.create(sbw)) {
            if (errorsOnly) {
                jw.startArray();
                for (PeachShardValidateReport report: result) {
                    if (!report.status()) {
                        continue;
                    }

                    jw.value(report);
                }
                jw.endArray();
            } else {
                jw.value(result);
            }
        } catch (IOException ioe) {
            context.session().logger().log(Level.WARNING, "Error", ioe);
            context.session().response(HttpStatus.SC_INTERNAL_SERVER_ERROR);
            return;
        }

        context.session().response(HttpStatus.SC_OK, sbw.toString());
    }
}
