package ru.yandex.ps.webtools.common.peach;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.search.web.DefaultPsProject;

public class PeachRequestContext {
    private final ProxySession session;
    private final String queueName;
    private final String hostname;
    private final String configName;
    private final int shard;
    private final AsyncClient client;

    public PeachRequestContext(
        final DefaultPsProject project,
        final ProxySession session)
        throws BadRequestException
    {
        this.queueName = session.params().getString("name");
        this.shard = session.params().getInt("shard", -1);
        this.configName = session.params().getString("config", "default");
        this.hostname = session.params().getString("host");
        this.session = session;
        this.client = project.searchClient().adjust(session.context());
    }

    public String queueName() {
        return queueName;
    }

    public String hostname() {
        return hostname;
    }

    public String configName() {
        return configName;
    }

    public int shard() {
        return shard;
    }

    public ProxySession session() {
        return session;
    }

    public AsyncClient client() {
        return client;
    }
}
