package ru.yandex.ps.webtools.common.peach;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class PeachShardValidateReport implements JsonValue {
    private final long shard;
    private final Collection<String> errors;
    private final List<BrokenRecordsRange> intervals;

    private final boolean status;

    public PeachShardValidateReport(
        final long shard,
        final Collection<String> errors,
        final List<BrokenRecordsRange> intervals,
        final boolean status)
    {
        this.shard = shard;
        this.errors = errors;
        this.intervals = intervals;
        this.status = status;
    }

    public boolean status() {
        return status;
    }

    @Override
    public void writeValue(final JsonWriterBase jw) throws IOException {
        jw.startObject();
        jw.key("shard");
        jw.value(shard);
        jw.key("status");
        jw.value(status);
        jw.key("intervals");
        jw.value(intervals);
        jw.key("errors");
        jw.value(errors);
        jw.endObject();
    }
}
