package ru.yandex.ps.webtools.common.peach;

import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;

final class SingleShardValidationResultPrinter
    extends AbstractProxySessionCallback<PeachShardValidateReport>
{
    private final PeachRequestContext context;

    public SingleShardValidationResultPrinter(final PeachRequestContext context) {
        super(context.session());

        this.context = context;
    }

    @Override
    public void completed(final PeachShardValidateReport result) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter jw = JsonType.NORMAL.create(sbw)) {
            jw.value(result);
        } catch (IOException ioe) {
            context.session().logger().log(Level.WARNING, "Error", ioe);
            context.session().response(HttpStatus.SC_INTERNAL_SERVER_ERROR);
            return;
        }

        context.session().response(HttpStatus.SC_OK, sbw.toString());
    }
}
