package ru.yandex.ps.webtools.disk;

import java.io.IOException;
import java.net.ConnectException;
import java.util.function.Function;

import ru.yandex.http.util.RequestErrorType;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.search.web.DefaultPsProject;
import ru.yandex.mail.search.web.WebApi;
import ru.yandex.mail.search.web.config.ImmutablePsProjectConfig;
import ru.yandex.mail.search.web.health.base.PsProjectType;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.ps.webtools.common.peach.DropPeachRecordsHandler;
import ru.yandex.ps.webtools.disk.peach.DiskPeachValidateRecordsHandler;

public class DiskWebtoolsProject extends DefaultPsProject {
    private static final Function<Exception, RequestErrorType>
        ERROR_CLASSIFIER
        = (e) -> {
        if (e instanceof ConnectException) {
            return RequestErrorType.HOST_NON_RETRIABLE;
        }

        return RequestErrorType.ERROR_CLASSIFIER.apply(e);
    };

    private final ImmutablePsProjectConfig config;
    private final AsyncClient searchClient;

    public DiskWebtoolsProject(
        final WebApi webApi,
        final PsProjectType project,
        final ImmutablePsProjectConfig config)
        throws IOException
    {
        super(webApi, project, config);

        this.config = config;

        searchClient =
            webApi.client(
                config.projectId() + "-SearchClient",
                config.searchConfig(),
                ERROR_CLASSIFIER);

        webApi.register(
            config,
            "/peach-validate",
            new DiskPeachValidateRecordsHandler(this, healthCheckService));
        webApi.register(
            config,
            "/peach-drop",
            new DropPeachRecordsHandler(this, healthCheckService));
    }

    @Override
    public void start() {
        super.start();
    }

    public SearchMap searchmap() {
        return searchmap;
    }

    public AsyncClient searchClient() {
        return searchClient;
    }
}
