package ru.yandex.ps.webtools.disk.peach;

import java.net.URI;
import java.net.URISyntaxException;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.mail.search.web.DefaultPsProject;
import ru.yandex.mail.search.web.health.HealthCheckService;
import ru.yandex.ps.webtools.common.peach.AbstractValidatePeachRecordsHandler;
import ru.yandex.ps.webtools.common.peach.PeachRecordCheckConsumer;

public class DiskPeachValidateRecordsHandler extends AbstractValidatePeachRecordsHandler {
    public DiskPeachValidateRecordsHandler(
        final DefaultPsProject project,
        final HealthCheckService health)
    {
        super(project, health);
    }

    @Override
    protected boolean validateRecord(
        final PeachRecordCheckConsumer consumer,
        final JsonMap task) {
        long version = -1;
        String id = null;

        String peachUrl;
        String payload;
        try {
            version = task.getInt("version");
            id = task.getString("id");
            peachUrl = task.getString("peach_url", null);
        } catch (JsonException je) {
            return consumer.invalid(
                task,
                version,
                "Invalid task format: "
                    + je.getMessage());
        }

        if (peachUrl == null) {
            return consumer.invalid(
                task,
                version,
                "Peach url is null");
        }

        try {
            new URI(peachUrl).parseServerAuthority();
        } catch (URISyntaxException e) {
            return consumer.invalid(
                task,
                version,
                "Unable parse url bad url detected: " + e.toString());
        }

        return consumer.valid(task, version);
    }
}
