# -*- coding: utf-8 -*-
"""
Django settings for mail_search_webtools project.

Generated by 'django-admin startproject' using Django 1.11.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

import os

#from django_yauth.settings import *

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import sys
from collections import OrderedDict

from django_pgaas import HostManager

from mail_search_webtools.webtools_modules import WEBTOOLS_PROJECTS_GROUPS, WEBTOOLS_PROJECTS

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.11/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'rw*6owpacj8cg98*j$e4qkjzfu5__bt!qaz%t#t35=g!m^wah&'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

WEBTOOLS_BALANCER = 'mail-search-tools.n.yandex-team.ru'
WEBTOOLS_DEV_BALANCER = 'mail-search-tools-dev.n.yandex-team.ru'
WEBTOOLS_API_HOST = 'http://localhost:' + str(os.environ.get('API_PORT'))
# 10mb
DATA_UPLOAD_MAX_MEMORY_SIZE = 10485760
ALLOWED_HOSTS = [WEBTOOLS_BALANCER, WEBTOOLS_DEV_BALANCER, '127.0.0.1']

SITE_ID = 1

# Application definition
STORAGE_HOST = 'http://storage.mail.yandex.net:10010'
AVA_HOST = 'http://avatars.mds.yandex.net'
# disk
DISK_HOSTS = {'disk_search_prod': {}, 'disk_search_test': {}}
DISK_HOSTS['disk_search_prod']['storage_host'] = 'http://storage.mail.yandex.net:10010'
DISK_HOSTS['disk_search_prod']['ava_host'] = 'http://avatars.mds.yandex.net'
DISK_HOSTS['disk_search_prod']['reindex_host'] = 'http://disk-producer.search.yandex.net:19922'
DISK_HOSTS['disk_search_prod']['check_index_host'] = 'http://sas1-1673-sas-disk-search-indexer-16171.gencfg-c.yandex.net:16171'
DISK_HOSTS['disk_search_prod']['smartcache_host'] = 'http://smartcache-worker.disk.yandex.net:80'
DISK_HOSTS['disk_search_prod']['proxy_host'] = 'http://disk-proxy-http.pers.yandex.net:80'
DISK_HOSTS['disk_search_prod']['face_in_queue'] = 'face_in_queue_prod'
DISK_HOSTS['disk_search_prod']['face_out_queue'] = 'disk_queue'

DISK_HOSTS['disk_search_test']['reindex_host'] = 'http://disk-producer-test.n.yandex-team.ru:80'
DISK_HOSTS['disk_search_test']['proxy_host'] = 'https://disk-secure-test.search.yandex.net'
DISK_HOSTS['disk_search_test']['face_in_queue'] = 'face_in_queue_test'
DISK_HOSTS['disk_search_test']['face_out_queue'] = 'face_out_queue_test'
DISK_HOSTS['disk_search_test']['storage_host'] = 'http://storage.stm.yandex.net:10010'
DISK_HOSTS['disk_search_test']['ava_host'] = 'http://avatars.mdst.yandex.net'

DISK_REINDEX_HOST = 'http://disk-producer.search.yandex.net:19922'
DISK_REINDEX_TAGS = ['disk_search_reindex_wait', 'disk_search_need_reindex']
DISK_SMARTCACHE_TAGS = ['disk_search_smartcache_need_update']
DISK_DROP_INDEXED_FIELDS_REQUEST = '/delete?service=disk_queue_offline&prefix={uid}&text=indexed_version:*'

#DISK_REINDEX_FAST_HOST = 'http://vla1-1635-vla-disk-search-indexer-24070.gencfg-c.yandex.net:24070'
DISK_REINDEX_URI = '/reindex?uri=/?action=reindex&uid={uid}&service-name=disk_queue_offline&batch-size=100&docs-per-request=50&service=disk_reindex_queue&prefix={uid}&cleanup'
DISK_FACE_REINDEX_URI = '/reindex?&prefix={uid}&version=1&cleanup&service={face_queue}'
DISK_REINDEX_SMARTCACHE_CALLBACK = 'http://smartcache-worker.disk.yandex.net:80/smartcache/smartcache-update-snapshot?__uid={uid}'
DISK_ALLOWED_PROJECTS = set(['disk_search_prod', 'disk_search_test'])
# mail
WEBTOOLS_MSEARCH_PROXY = 'http://msearch-proxy-qa.search.yandex.net:14550'
# aceventura
ACEVENTURA_PROXY_HOST = 'https://aceventura-search-qa.n.yandex-team.ru:443'
ACEVENTURA_SALO_HOST = 'http://vla2-8345-a64-vla-abook-producer-14646.gencfg-c.yandex.net:81'
#so_fraud
SO_FRAUD_PROXY_HOST = "http://so-fraud-proxy.pers.yandex.net"
SO_FRAUD_BACKEND_HOST = "http://so-fraud.pers.yandex.net"

# common
DEFAULT_YANDEX_USER = None
WEBTOOLS_SESSION_CHECK_RETRIES = 10

YAUTH_SESSIONID2_REQUIRED = False

WEBTOOLS_MODULES = WEBTOOLS_PROJECTS
WEBTOOLS_MODULES_GROUPS = WEBTOOLS_PROJECTS_GROUPS
# {
#     'IEX': {
#         'Facts': ,
#         'News Images': 'iex.images.template',
#         'Remorph': 'iex.remorph'
#     },
#     'Почта Production': {
#         'project_id'
#         'Здоровье Прод': 'mail_search_prod.health.info',
#         'Здоровье Тест': 'mail_search_test.health.info',
#         'Поиск в люцене': 'mail_search_lucene_query',
#         'Поиск': 'mail_search',
#         'Info': 'mail_search_info',
#         'Переиндексация': 'mail_search_reindex',
#
#
#         'Lucene': 'mail_search_lucene',
#         'Filter Search': 'mail_search_filter_search',
#         'Snippet': 'mail_search_snippet',
#     },
#     'Диск': {
#         'SbS': 'disk.search.sbs',
#         'Переиндексация': 'disk.search.reindex',
#         'Очередь': 'disk.search.queue',
#         'Info': 'disk.search.info',
#     },
#     'Люцена': {
#         'Скопировать шард': 'lucene.copy_shard',
#     }
# }

if os.environ.get('WEBTOOLS_CLUSTER') == 'dev':
    WEBTOOLS_API_HOST = 'http://mail-search-tools.n.yandex-team.ru/api'
    DISK_REINDEX_HOST = 'http://man1-7315.search.yandex.net:19922'
    DISK_HOSTS['disk_search_prod']['proxy_host'] = 'http://localhost:9999'
    STORAGE_HOST = 'http://localhost:9998'
    AVA_HOST = 'http://localhost:9997'
    DEFAULT_YANDEX_USER = 'vonidu'
    DEBUG = True

    LOGGING = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'verbose': {
                'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'
            },
        },
        'handlers': {
            'django-file': {
                'level': 'DEBUG',
                'class': 'logging.StreamHandler',
                'stream': sys.stdout,
                'formatter': 'verbose'
            },
            'usermarks-file': {
                'level': 'DEBUG',
                'stream': sys.stdout,
                'class': 'logging.StreamHandler',
            },
        },
        'loggers': {
            'django': {
                'handlers': ['django-file'],
                'level': 'DEBUG',
                'propagate': True,
            },
            'usermarks': {
                'handlers': ['usermarks-file'],
                'level': 'DEBUG',
                'propagate': True,
            },
        },
    }
else:
    LOGGING = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'verbose': {
                'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'
            },
        },
        'handlers': {
            'django-file': {
                'level': 'DEBUG',
                'class': 'logging.handlers.RotatingFileHandler',
                'maxBytes': 1024 * 1024 * 500,
                'backupCount': 10,
                'filename': '/logs/django.log',
                'formatter': 'verbose'
            },
            'usermarks-file': {
                'level': 'DEBUG',
                'class': 'logging.FileHandler',
                'filename': '/logs/usermarks.log',
            },
        },
        'loggers': {
            'django': {
                'handlers': ['django-file'],
                'level': 'DEBUG',
                'propagate': True,
            },
            'usermarks': {
                'handlers': ['usermarks-file'],
                'level': 'DEBUG',
                'propagate': True,
            },
            'django.template': {
                'handlers': ['django-file'],
                'level': 'INFO',
                'propagate': True,
            },
        },
    }

INSTALLED_APPS = [
    #'django_yauth',
    'django_pgaas',
    'django_template_common',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'webtools'
]

YAUTH_TYPE = 'intranet'

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'mail_search_webtools.middleware.MailSearchAdminAuthMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

# AUTHENTICATION_BACKENDS = [
#         'django_yauth.authentication_mechanisms.cookie.Mechanism',
# ]

ROOT_URLCONF = 'mail_search_webtools.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

TEMPLATE_CONTEXT_PROCESSORS = (
        'django_yauth.context.yauth',
    )

WSGI_APPLICATION = 'mail_search_webtools.wsgi.application'

DB_PASSWORD = os.environ.get('WEBTOOLS_DB_PASSWORD')
if not DB_PASSWORD:
    raise RuntimeError('No WEBTOOLS_DB_PASSWORD supplied')

PG_HOSTS=[
    ('sas-hccvwgawlrp06cqu.db.yandex.net', 'sas'),
    ('man-memg6sjvhyo57t4c.db.yandex.net', 'man'),
    ('vla-yr6wnlh0hi1rhzz5.db.yandex.net', 'vla'),
]

pgaas_manager = HostManager(PG_HOSTS, os.getenv("a_dc", "").lower())

DATABASES = {
    'default': {
        'ENGINE': 'django_pgaas.backend',
        'NAME': 'mail_search_admin',
        'USER' : 'mail_search',
        'PASSWORD': DB_PASSWORD,
        'OPTIONS': {
            "target_session_attrs": "read-write"
        },
        'HOST' : pgaas_manager.host_string,
        'PORT' : 6432,
    }
}


# Password validation
# https://docs.djangoproject.com/en/1.11/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/1.11/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Europe/Moscow'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = '/static'
HEATMAP_FILE_PATTERN = 'heatmap_{service}.png'
