# -*- coding: utf-8 -*-
import os
from collections import OrderedDict

HEALTH_MODULE = {'name': 'Health', 'url': 'common.lucene.health', 'title': 'Lucene Health', 'description': 'Состояние шардов в разрезе реплик'}
HEALTH_DROP_INFO = {'name': 'HealthDropInfo', 'url': 'common.lucene.health.drop.page', 'title': 'Дропнуть шард', 'description': 'Понять можно ли дропать шард'}
QUEUE = {'name': 'Queue', 'url': 'common.queue.get', 'title': 'Очередь', 'description': 'Достать элемент из очереди по queueId, shard и service'}
BACKEND_SEARCH = {'name': 'BackendSearch', 'url': 'common.backend.search', 'title': 'Поиск в люцене', 'description': 'Поискать в люцене напрямую'}
#
# Mail prod
FACTS_MODULE = {'name': 'Facts', 'url': 'mail.iex.facts', 'title': 'Факты', 'description': 'Достать факты из люены по uid/mid'}
REMORPH_MODULE = {'name': 'Remorph', 'url': 'mail.iex.remorph', 'title': 'Remorph', 'description': 'Проверить как отработает remorph'}
MAIL_SEARCH_SEARCH_MODULE = {'name': 'Search', 'url': 'mail.mail_search', 'title': 'Поиск', 'description': 'Проверить как работает поиск у пользователя'}
MAIL_SEARCH_INFO_MODULE = {'name': 'MailSearchInfo', 'url': 'mail.search.info', 'title': 'Инфо', 'description': 'Информация по письму из lucene/filter-search/queue etc'}
MAIL_CHECK_INDEX = {'name': 'MailCheckIndex', 'url': 'mail.search.index_check', 'title': 'Пров. Индекс Польз.', 'description': 'Проверить индекс пользователя Fast/Peach/По Папкам'}
MAIL_SEARCH_REINDEX = {'name': 'MailSerchReindex', 'url': 'mail.search.reindex', 'title': 'Переиндекси. Польз.', 'description': 'Периндексация пользователя'}
MAIL_SEARCH_FILTER_SEARCH = {'name': 'MailSearchFS', 'url': 'mail.search.filter.search', 'title': 'Filter-Search', 'description': 'Показать выдачу filter-search по uid/mid'}

MAIL_SUBPROJECTS = [
    {'name': 'search', 'title': 'Поиск', 'description': 'Поиск по почте',
     'modules': [MAIL_SEARCH_INFO_MODULE, MAIL_CHECK_INDEX,
                 HEALTH_MODULE, HEALTH_DROP_INFO, MAIL_SEARCH_REINDEX, QUEUE,
                 BACKEND_SEARCH, MAIL_SEARCH_FILTER_SEARCH, MAIL_SEARCH_SEARCH_MODULE]},
    {'name': 'iex', 'title': 'IEX', 'modules': [FACTS_MODULE, REMORPH_MODULE]}]


MAIL_PROD = {
    'id': 'mail_search_prod',
    'title': 'Почта.Prod',
    'description': 'Поиск по почте (Production)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_mail_bp_prod.txt',
    'projects': MAIL_SUBPROJECTS
}

MAIL_CORP = {
    'id': 'mail_search_corp',
    'title': 'Почта.Corp',
    'description': 'Поиск по почте (Corp)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_mail_corp.txt',
    'projects': MAIL_SUBPROJECTS
}

#so_fraud
SO_FRAUD_LOG_TAIL = {
    'name': 'SoFraudLogTail',
    'url': 'so_fraud.log.tail',
    'title': 'Последние транзакции',
    'description': 'Топ последних транзакций'
}

SO_FRAUD_LIST_CREATE = {
    'name': 'SoFraudCreateList',
    'url': 'so_fraud.create_list',
    'title': 'Изменить списки',
    'description': 'Изменить списки'
}

SO_FRAUD_LISTS_SEARCH = {
    'name': 'SoFraudListsSearch',
    'url': 'so_fraud.lists_search',
    'title': 'Списки',
    'description': 'Списки'
}

SO_FRAUD_TRANSACTIONS_SEARCH = {
    'name': 'SoFraudTransactionsSearch',
    'url': 'so_fraud.transactions_search',
    'title': 'Поиск транзакций',
    'description': 'Поиск транзакций'
}

SO_FRAUD_SUBPROJECTS = [{
    'name': 'so_fraud',
    'title': 'Антитраст',
    'description': 'Антитраст во фроде',
    'modules': [SO_FRAUD_LOG_TAIL, SO_FRAUD_LIST_CREATE, SO_FRAUD_LISTS_SEARCH, SO_FRAUD_TRANSACTIONS_SEARCH]
}]

SO_FRAUD_PROD = {
    'id': 'so_fraud_prod',
    'title': 'Антитраст.PROD',
    'description': 'Антифрод в трасте',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/so_fraud_prod.txt',
    'projects': SO_FRAUD_SUBPROJECTS
}

# aceventura
CONTACTS_SUGGEST = {'name': 'AceventuraSuggest', 'url': 'aceventura.suggest.template', 'title': 'Саджест', 'description': 'Саджест'}
CONTACTS_REINDEX = {'name': 'AceventuraCheckIndex', 'url': 'aceventura.check_index.template', 'title': 'Проверить Индекс', 'description': 'Проверить Индекс'}
CONTACTS_SUBPROJECTS = [{'name': 'search', 'title': 'Поиск', 'description': 'Поиск по контактам', 'modules': [HEALTH_MODULE, QUEUE, BACKEND_SEARCH, CONTACTS_SUGGEST, CONTACTS_REINDEX]},]

CONTACTS_PROD = {
    'id': 'contacts_search_prod',
    'title': 'Контакты (Прод)',
    'description': 'Поиск по контактам (Прод)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_aceventura_prod.txt',
    'projects': CONTACTS_SUBPROJECTS
}

# messenger
MESSENGER_SUGGEST = {'name': 'MessengerSuggest', 'url': 'messenger.suggest.template', 'title': 'Саджест', 'description': 'Саджест'}
MESSENGER_SUBPROJECTS = [{'name': 'search', 'title': 'Поиск', 'description': 'Поиск', 'modules': [HEALTH_MODULE, QUEUE, BACKEND_SEARCH, MESSENGER_SUGGEST]},]

MESSENGER_CHATS_PROD = {
    'id': 'messenger_search_chats_prod',
    'title': 'Мессенджер (Чаты-Прод)',
    'description': 'Мессенджер поиск (Чаты-Прод)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_messenger_chats_prod.txt',
    'projects': MESSENGER_SUBPROJECTS
}

MESSENGER_MESSAGES_PROD = {
    'id': 'messenger_search_messages_prod',
    'title': 'Мессенджер (Сообщ-Прод)',
    'description': 'Мессенджер поиск (Сообщ-Прод)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_messenger_messages_prod.txt',
    'projects': MESSENGER_SUBPROJECTS
}

# Disk prod
DISK_SEARCH_REINDEX = {'name': 'DiskSearchReindex', 'url': 'disk.search.reindex', 'title': 'Переиндекс. Польз.', 'description': 'Периндексация пользователя'}
DISK_FACES = {'name': 'DiskFaces', 'url': 'disk.faces.list', 'title': 'Лица', 'description': 'Лица'}
DISK_SUBPROJECTS = [{'name': 'search', 'title': 'Поиск', 'description': 'Поиск по диску', 'modules': [DISK_SEARCH_REINDEX, DISK_FACES, HEALTH_MODULE, QUEUE, BACKEND_SEARCH]},]
DISK_PROD = {
    'id': 'disk_search_prod',
    'title': 'Диск.Prod',
    'description': 'Поиск по диску (Production)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_disk_prod.txt',
    'projects': DISK_SUBPROJECTS
}

#Test
MAIL_TEST = {
    'id': 'mail_search_test',
    'title': 'Почта.Test',
    'description': 'Поиск по почте (Testing)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_mail_test.txt',
    'projects': MAIL_SUBPROJECTS
}

DISK_TEST = {
    'id': 'disk_search_test',
    'title': 'Диск.Test',
    'description': 'Поиск по диску (Testing)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_disk_test.txt',
    'projects': DISK_SUBPROJECTS
}

#District
DISTRICT_SUBPROJECTS = [{'name': 'search', 'title': 'Поиск', 'description': 'Поиск по районам', 'modules': [HEALTH_MODULE, QUEUE, BACKEND_SEARCH]},]
DISTRICT_PROD = {
    'id': 'district_prod',
    'title': 'Районы.Prod',
    'description': 'Поиск Районы (Production)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_district_prod.txt',
    'projects': DISTRICT_SUBPROJECTS
}

DISTRICT_TEST = {
    'id': 'district_test',
    'title': 'Районы.Test',
    'description': 'Поиск Районы (Testing)',
    'searchmap': os.environ.get('BSCONFIG_IDIR', './') + '/searchmap_district_test.txt',
    'projects': DISTRICT_SUBPROJECTS
}

MAIL_PROJECTS_GROUP = {"title": "Почта", "projects":[MAIL_PROD, MAIL_CORP, MAIL_TEST]}
DISK_PROJECTS_GROUP = {"title": "Диск", "projects":[DISK_PROD, DISK_TEST]}
MESSENGER_PROJECTS_GROUP = {"title": "Мессенджер", "projects":[MESSENGER_CHATS_PROD, MESSENGER_MESSAGES_PROD]}
CONTACTS_GROUP = {"title": "Контакты", "projects":[CONTACTS_PROD]}
DISTRICT_PROJECTS_GROUP = {"title": "Районы", "projects":[DISTRICT_PROD, DISTRICT_TEST]}
SO_FRAUD_GROUP = {'title': 'Антитраст', 'projects':[SO_FRAUD_PROD]}

WEBTOOLS_PROJECTS_GROUPS = [MAIL_PROJECTS_GROUP, DISK_PROJECTS_GROUP, MESSENGER_PROJECTS_GROUP, CONTACTS_GROUP, DISTRICT_PROJECTS_GROUP, SO_FRAUD_GROUP]
WEBTOOLS_PROJECTS = OrderedDict()

for group in WEBTOOLS_PROJECTS_GROUPS:
    for item in group['projects']:
        WEBTOOLS_PROJECTS[item['id']] = item
