# -*- coding: utf-8 -*-
import json
import urllib

import requests
import traceback
from django.contrib.admin.views.decorators import staff_member_required
from django.contrib.auth.decorators import user_passes_test

from django.http import HttpResponse, HttpResponseServerError
from django.template import loader

from mail_search_webtools import settings
from mail_search_webtools.settings import WEBTOOLS_MODULES, ACEVENTURA_PROXY_HOST
from webtools.views_utils import default_context


ACE_SUGGEST_URI = '/v1/suggest?user_id={uid}&user_type=passport_user&shared=include&limit={limit}&query={query}'

def user_in_group(user, group):
    return user.groups.filter(name=group).exists()

def check_user_mail_manager(user):
    manager_status = user.is_active and (user.is_superuser or user_in_group(user, 'mail_manager'))
    print 'Manager status', manager_status, user
    return user.is_active and (user.is_superuser or user_in_group(user, 'mail_manager'))

@staff_member_required
def suggest_api(request, project):
    uid = request.GET.get('uid')
    query = request.GET.get('query')
    extra_params = request.GET.copy()
    del extra_params['uid']
    del extra_params['query']

    uri = ACEVENTURA_PROXY_HOST
    limit = 5
    if not query:
        limit = 50
    query = urllib.quote_plus(query.encode('utf-8'))
    uri += ACE_SUGGEST_URI.format(uid=uid, query=query, limit=limit)

    resp = requests.get(uri, extra_params)
    if resp.status_code != 200:
        return HttpResponse(resp.status_code, resp.content)

    data = resp.json()
    print uri, data
    contacts = data['contacts']
    result = []
    for contact in contacts:
        if contact['emails']:
            email = contact['emails'][0]['value']
        else:
            email = 'NoEmail'

        names = contact['vcard'].get('names', [])
        if names:
            name = names[0].get('last', '')
            name += ' '
            name += names[0].get('first', '')
        else:
            name = "Unknown Name"

        result.append({'text': name + ' ' + email, 'name': name, 'email': email})

    return HttpResponse(json.dumps(result))

@staff_member_required
def suggest_template(request, project):
    template = loader.get_template('aceventura/suggest.html')

    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError(project + ' not found')

    context = {
        'request_text': request.GET.get('request_text', ''),
        'suggest_display_field': 'text'
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))

@user_passes_test(check_user_mail_manager)
def check_index(request, project):
    USER_TYPES = [{'name': 'passport_user', 'selected': False}, {'name': 'connect_organization', 'selected': False}]
    CHECK_MODES = [{'name': 'fast', 'selected': False}, {'name': 'full', 'selected': False}]
    user_id = request.GET.get('user_id')
    user_type_str = request.GET.get('user_type')
    action = request.GET.get('action')
    check_mode_str = request.GET.get('check_mode')
    result = None
    collapse = 'false'
    user_type = None
    if user_type_str:
        for ut in USER_TYPES:
            if ut['name'] == str(user_type_str).lower():
                user_type = ut['name']
                ut['selected'] = True

    check_mode = 'fast'
    if check_mode_str:
        for cm in CHECK_MODES:
            if cm['name'] == str(check_mode_str).lower():
                check_mode = cm['name']
                cm['selected'] = True

    print user_id, user_type, user_type_str,action
    if user_id and user_type:

        check_url = settings.WEBTOOLS_API_HOST + '/' + project + '/check/index/'
        if action == 'check':
            if check_mode == 'full':
                check_url += 'full?'
            else:
                check_url += 'fast?'

            check_url += 'user=' + str(user_id)  + '$' + str(user_type)
            try:
                resp = requests.get(check_url, timeout=60)
                if resp.status_code == 200:
                    result = resp.json()
                else:
                    result = {'status': 'error', 'error': resp.content, 'code': resp.status_code}
            except:
                result = {'status': 'error', 'error': traceback.format_exc()}
                traceback.print_exc()

        if action == 'reindex':
            reindex_uri = '/reindex-user?user_id={user_id}&user_type={user_type}&shared={shared}&provider={provider}'
            shared = 'passport_user' == user_type
            reindex_url = settings.ACEVENTURA_SALO_HOST
            reindex_url += reindex_uri.format(user_id=user_id, user_type=user_type, shared=shared, provider='acebp')
            try:
                resp = requests.get(reindex_url, timeout=300)
                if resp.status_code == 200:
                    result = {'status': 'ok', 'message': 'reindexed'}
                else:
                    result = {'status': 'error', 'error': resp.content, 'code': resp.status_code}
            except:
                result = {'status': 'error', 'error': traceback.format_exc()}
                traceback.print_exc()

    context = {
        'index_status': json.dumps(result),
        'has_status': result is not None,
        'user_id': user_id,
        'user_type': user_type,
        'user_types': USER_TYPES,
        'check_modes': CHECK_MODES,
        'collapse': collapse
    }

    template = loader.get_template('aceventura/check_index.html')
    context.update(default_context(request, project))
    return HttpResponse(template.render(context, request))

