# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.contrib import admin

# Register your models here.
from webtools.models import LinkedYandexUser, UserReindexation, ManualCopyJob, LuceneDropShard


class LinkedYandexUserAdmin(admin.ModelAdmin):
    list_display = ('user', 'uid', 'login', 'first_name', 'last_name', 'email')


class UserReindexationAdmin(admin.ModelAdmin):
    list_display = ('uid', 'user', 'component', 'status', 'ticket', 'reindex_date_start', 'reindex_date_start')
    #list_display = ('uid', 'user', 'component', 'status', 'reindex_date')

class ManualCopyJobAdmin(admin.ModelAdmin):
    list_display = ('dest_host', 'get_shard_range', 'service', 'status', 'start_date', 'finish_date', 'user')

    def get_shard_range(self, job):
        return str(job.start_shard) + '-' + str(job.end_shard)

class LuceneDropShardAdmin(admin.ModelAdmin):
    list_display = ('component', 'host', 'shard', 'lucene_shard', 'drop_date', 'user', 'status')


admin.site.register(LinkedYandexUser, LinkedYandexUserAdmin)
admin.site.register(UserReindexation, UserReindexationAdmin)
admin.site.register(ManualCopyJob, ManualCopyJobAdmin)
admin.site.register(LuceneDropShard, LuceneDropShardAdmin)
