# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import json
import urllib
from collections import OrderedDict

import datetime
import urlparse
from wsgiref.util import is_hop_by_hop

import pytz
import requests
from django.contrib.admin.views.decorators import staff_member_required

from django.contrib.auth.decorators import login_required

from django.http import HttpResponse, HttpResponseServerError
from django.template import loader
from django.contrib.auth.models import Group

from mail_search_webtools.settings import WEBTOOLS_MODULES

DEFAULT_OPTIONS = OrderedDict()
DEFAULT_OPTIONS['lucene'] = {'id': 'luceneCbx', 'label': 'Люцена', 'param': 'lucene', 'checked': False}
DEFAULT_OPTIONS['allbackends'] = {'id': 'allbackendsCbx', 'label': 'Все бекенды', 'param': 'lucene-allbackends', 'checked': False}
DEFAULT_OPTIONS['queue'] = {'id': 'queueCbx', 'label': 'Queue', 'param': 'queue', 'checked': False}


@staff_member_required
def disk_search_queue(request):
    template = loader.get_template('disk/disk_search_info.html')

    options = copy_options()
    options['queue']['checked'] = True

    context = {
        'user': request.user,
        'options': options.values(),
        'collapsed': False,
        'options_js': json.dumps(options.values()),
        'modules': WEBTOOLS_MODULES
    }

    return HttpResponse(template.render(context, request))


@staff_member_required
def disk_search_info(request):
    template = loader.get_template('disk/disk_search_info.html')

    options = copy_options()
    for option in options.keys():
        options[option]['checked'] = True

    context = {
        'user': request.user,
        'options': options.values(),
        'collapsed': False,
        'options_js': json.dumps(options.values()),
        'modules': WEBTOOLS_MODULES
    }

    return HttpResponse(template.render(context, request))


def copy_options():
    options = OrderedDict(**DEFAULT_OPTIONS)
    for k, v in DEFAULT_OPTIONS.iteritems():
        option = dict(**v)
        options[k] = option

    return options


def get_user_channels_map(user):
    channels = {}

    for channel_uri in get_user_channels(user):
        channel, subchannel = channel_uri.split('/')
        channels.setdefault(channel, []).append(subchannel)

    return channels


def get_user_channels(user):
    channels = []

    groups = Group.objects if user.is_superuser else user.groups

    for g in groups.filter(name__startswith="af."):
        channels.append(g.name[3:].lower())

    return channels
