# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import json
import traceback
import urllib
import re
import logging
from collections import OrderedDict

import requests
import datetime
import time

from django.contrib.admin.views.decorators import staff_member_required
from django.contrib.auth.decorators import user_passes_test, login_required
from django.contrib.auth.models import User

from django.http import HttpResponse, HttpResponseServerError, StreamingHttpResponse
from django.urls import reverse
from django.template.defaulttags import register
from requests.adapters import HTTPAdapter
from django.views.decorators.csrf import csrf_exempt

from webtools.startrek_wrapper import client as st_client

from mail_search_webtools.settings import DISK_REINDEX_URI, \
    DISK_REINDEX_HOST, DISK_REINDEX_SMARTCACHE_CALLBACK, WEBTOOLS_BALANCER, DISK_ALLOWED_PROJECTS, WEBTOOLS_MODULES, \
    DISK_DROP_INDEXED_FIELDS_REQUEST, DISK_HOSTS, DISK_FACE_REINDEX_URI, DISK_REINDEX_TAGS, DISK_SMARTCACHE_TAGS
from mail_search_webtools.webtools_modules import WEBTOOLS_PROJECTS, DISK_PROJECTS_GROUP
from webtools.models import LinkedYandexUser, UserReindexation, ManualCopyJob, COPY_JOB_STATUSES
from django.template import loader

from webtools.views import default_context,proxy_host_request

log = logging.getLogger('django')

def user_in_group(user, group):
    return user.groups.filter(name=group).exists()

def check_user_disk_manager(user):
    manager_status = user.is_active and (user.is_superuser or user_in_group(user, 'disk_manager'))
    print 'Manager status', manager_status, user
    return user.is_active and (user.is_superuser or user_in_group(user, 'disk_manager'))

#VIDEO_PREVIEW_API_HOST = 'http://[2a02:6b8:c1b:2196:100:459:3361:0]:8120'
VIDEO_PREVIEWS_STATIC_IMG_HOST = 'http://vonidu-mail-search-dev.sas.yp-c.yandex.net:8000'
VIDEO_PREVIEWS_API_HOST = 'http://vonidu-mail-search-dev.sas.yp-c.yandex.net:8120'
VIDEO_PREVIEWS_API_LUCENE_HOST = 'http://vonidu-mail-search-dev.sas.yp-c.yandex.net:13001'

@user_passes_test(check_user_disk_manager)
def api_reindex(request, project):
    if project not in WEBTOOLS_PROJECTS:
        return HttpResponseServerError('Project not found ' + project)

    uid = request.GET.get('uid')
    if not uid:
        return HttpResponse(status=400, content='Bad uid ' + uid)

    smartcache = int(request.GET.get('smartcache', 0))
    hard = int(request.GET.get('hard', 0))
    #fastindex = int(request.GET.get('fastreindex', 0))
    print request.GET
    # if fastindex:
    #     reindex_uri = DISK_REINDEX_FAST_HOST
    # else:
    subservices = ['disk', 'face']
    uidStr = request.GET.get('uid')
    subservice = request.GET.get('subservice', 'disk')
    uid = 0
    try:
        uid = int(uidStr)
    except:
        print "Invalid uid", uidStr

    if subservice not in subservices:
        return HttpResponse(status=500, content="Invalid subserviсe supplied " + subservice)

    if not uid:
        return HttpResponse(status=500, content="Invalid uid supplied " + uidStr)

    ur = UserReindexation()
    ur.uid = uid
    ur.component = project
    ur.subservice = subservice
    ur.user = request.user
    ur.reindex_date_start = datetime.datetime.now()
    ur.reindex_date = datetime.datetime.now()
    ur.save()

    reindex_uri = DISK_HOSTS[project]['reindex_host']
    face_queue = DISK_HOSTS[project]['face_in_queue']
    if subservice == 'disk':
        reindex_uri += DISK_REINDEX_URI.format(uid=str(uid))
        reindex_callback = 'http://' + WEBTOOLS_BALANCER
        reindex_callback += reverse('disk.search.api.reindex.completed', kwargs={'project': project})
        reindex_callback += '?uid={uid}&rid={rid}'

        reindex_uri += '&' + urllib.urlencode({'callback': reindex_callback.format(uid=uid, rid=ur.id)})
        if smartcache:
            reindex_uri += '&' + urllib.urlencode({'callback': DISK_REINDEX_SMARTCACHE_CALLBACK.format(uid=uid)})
    elif subservice == 'face':
        reindex_uri += DISK_FACE_REINDEX_URI.format(uid=str(uid), face_queue=face_queue)
        reindex_callback = 'http://' + WEBTOOLS_BALANCER
        reindex_callback += reverse('disk.search.api.reindex.completed', kwargs={'project': project})
        reindex_callback += '?uid={uid}&rid={rid}'
        reindex_uri += '&' + urllib.urlencode({'callback': reindex_callback.format(uid=uid, rid=ur.id)})

    if hard:
        drop_indexed_uri = DISK_REINDEX_HOST + DISK_DROP_INDEXED_FIELDS_REQUEST.format(uid=uid)
        print 'Drop indexed uri', drop_indexed_uri
        resp = requests.get(drop_indexed_uri, timeout=60)
        if resp.status_code != 200:
            print 'Drop request failed', resp.content
            ur.delete()
            return HttpResponse(status=resp.status_code, content=resp.content)

        print 'indexed_ records Dropped', drop_indexed_uri

    resp = requests.get(reindex_uri, timeout=60)
    if resp.status_code != 200:
        ur.delete()
        return HttpResponse(status=resp.status_code, content=resp.content)

    ur.status = 'STARTED'

    ur.save()

    response_data = {'uid': uid, 'reqid': ur.id}
    return HttpResponse(status=200, content=json.dumps(response_data))

def do_launch_disk_reindex(project, uid, user, ticket, smartcache, hard, remove_tags=list(DISK_REINDEX_TAGS)):
    ur = UserReindexation()
    ur.uid = uid
    ur.component = project
    ur.subservice = 'disk'
    ur.user = user
    ur.reindex_date_start = datetime.datetime.now()
    ur.reindex_date = datetime.datetime.now()
    if ticket:
        ur.ticket = ticket

    ur.save()

    reindex_uri = DISK_HOSTS[project]['reindex_host']

    reindex_uri += DISK_REINDEX_URI.format(uid=str(uid))
    reindex_callback = 'http://' + WEBTOOLS_BALANCER
    reindex_callback += reverse('disk.search.api.reindex.completed', kwargs={'project': project})
    reindex_callback += '?uid={uid}&rid={rid}&tags={tags}'
    if smartcache:
        reindex_callback += '&smartcache=True'
    if hard:
        reindex_callback += '&hard=True'

    reindex_uri += '&' + urllib.urlencode({'callback': reindex_callback.format(uid=uid, rid=ur.id, tags=','.join(remove_tags))})
    if smartcache:
        reindex_uri += '&' + urllib.urlencode({'callback': DISK_REINDEX_SMARTCACHE_CALLBACK.format(uid=uid)})

    reindex_session = requests.Session()
    reindex_session.mount(
        DISK_HOSTS[project]['reindex_host'],
        HTTPAdapter(max_retries=3))

    if hard:
        drop_indexed_uri = DISK_HOSTS[project]['reindex_host'] + DISK_DROP_INDEXED_FIELDS_REQUEST.format(uid=uid)
        print 'Drop indexed uri', drop_indexed_uri
        resp = reindex_session.get(drop_indexed_uri, timeout=60)
        if resp.status_code != 200:
            print 'Drop request failed', resp.content
            ur.delete()
            return 'Error', resp.content

        print 'indexed_ records Dropped', drop_indexed_uri

    resp = reindex_session.get(reindex_uri, timeout=60)
    if resp.status_code != 200:
        ur.delete()
        return 'Error', resp.content

    ur.status = 'STARTED'

    ur.save()

    return 'OK', ur.id

def ticket_fail(issue, text, remove_tags=DISK_REINDEX_TAGS + DISK_SMARTCACHE_TAGS):
    issue.comments.create(text=text)
    if remove_tags:
        issue = st_client.issues[issue.key]
        to_remove = []
        for tag in remove_tags:
            if tag in issue.tags:
                to_remove.append(tag)

        issue.update(tags={'remove': to_remove})

def parse_string_list(storage, name, default_value=[]):
    value_str = storage.get(name, '')
    if value_str:
        return value_str.split(',')

    return default_value

def parse_startrek_notification(request):
    ticket = request.META.get('HTTP_X_STARTREK_KEY', None)
    uid = request.META.get('HTTP_X_YANDEX_UID', None)

    if not ticket:
        ticket = request.GET.get('ticket')

    if not uid:
        uid = request.GET.get('uid')

    tags = parse_string_list(request.GET, 'tags', list())
    description = ''
    if not ticket or not uid:
        data = json.loads(request.body.decode('utf-8'))
        if not ticket:
            ticket = data.get('key', None)

        if not uid:
            uid = data.get('uid', None)

        if not uid:
            description = data.get('description', '')
            uid_regexp = re.compile(r'uid[^\w\s]*:\s*(\d+)')
            match = re.findall('uid:\s+([0-9]+)', description.lower())
            if match:
                uid = match[0]
        if not tags:
            tags = parse_string_list(data, 'tags', list())

    if not uid:
        log.warn('Uid not found ' + description)
    # uid = ''
    # for m in re.finditer(uid_regexp, description.lower()):
    #     uid = m.group(1)
    #     if uid:
    #         try:
    #             uid = int(uid)
    #         except:
    #             print 'Uid found, but not integer', uid
    #             continue
    #
    #         print 'Uid found:', uid
    return uid, ticket, tags

def launch_smartcache_update(project, uid):
    log.info("Launching smartcache update")
    smche_host = DISK_HOSTS['disk_search_prod']['smartcache_host']
    smche_session = requests.Session()
    smche_session.mount(smche_host, HTTPAdapter(max_retries=5))

    resp = smche_session.get(smche_host + '/smartcache/smartcache-update-snapshot?&__uid={uid}'.format(uid=uid))
    if resp.status_code > 299:
        return HttpResponse(status=resp.status_code, content='Smartcache return error')

    return HttpResponse(status=200, content='OK')

def print_index_status_in_ticket(project, ticket, uid):
    callback = 'http://' + WEBTOOLS_BALANCER
    callback += reverse('disk.search.api.ticket.created', kwargs={'project': project})
    callback += '?uid={uid}&ticket={ticket}&completed=1'

    request_url = DISK_HOSTS[project]['reindex_host']
    request_url += '/check_index?uid={uid}&compare=true&check_photoslice=true&service=disk_reindex_queue&prefix={uid}'
    request_url += "&" + urllib.urlencode({'callback': callback.format(uid=uid, ticket=ticket)})
    retries = 0
    while retries < 5:
        try:
            resp = requests.get(request_url.format(host=DISK_HOSTS[project]['check_index_host'], uid=uid))
            if resp.status_code == 200:
                break
            retries += 1
        except:
            retries += 1

        time.sleep(retries)

    if resp.status_code != 200:
        log.warn('check index failed for ' + str(uid) + ' ' + str(resp.status_code))
        log.warn(resp.content)
        return HttpResponse(status=400, content='Error')

    return HttpResponse(status=200, content="OK")

support_comment_text = '''<{{Диагностическая информация для дежурного
%%
Пользователь: {uid}
Статус индекса: {index_status}
Число дубликатов resource_id: {index_duplicates_cnt}
Число отсутствующих ресурсов {index_not_found_cnt}
Фастмувный и обычный фотосрез совпадают {photoslice_fast_move_and_not_coincide}
Размер фотосреза {photoslice_total}
Размер фастмувного фотосреза {photoslice_fast_moved_total}
Размер фотосреза последний месяц {photoslice_total_last_month}
Producer actual main {producer_actual_main}
Producer actual reindex {producer_actual_reindex}
Producer actual main not reindex {producer_actual_main_not_reindex}
Папок (без корзины) {index_folders_not_trash}
Файлов (без корзины) {index_files_not_trash}
Картинок (без корзины) {index_images_not_trash}
Видео (без корзины) {index_videos_not_trash}
Папок в корзине {index_folders_trash}
Файлов в корзине {index_files_trash}

Первые 20 отстутствующих ресурсов {index_first_missing_resources}
Первые 20 дубликатов {index_first_duplicates}
%%
}}>
'''

@csrf_exempt
def support_ticket_created(request, project):
    uid, ticket, tags = parse_startrek_notification(request)

    if not ticket or not uid:
        log.warn('No ticket or uid found ' + unicode(request.META))
        return HttpResponse(status=400, content='No ticket supplied')

    log.info("Got uid {uid} ticket {ticket} tags {tags}".format(uid=uid, ticket=ticket, tags=tags))

    if request.GET.get('completed') == '1':
        check_data = json.loads(request.body)
        try:
            issue = st_client.issues[ticket]

            kv = {'uid': uid, 'ticket': ticket}
            index = check_data['index']
            kv['index_status'] = index['ok']
            kv['index_not_found_cnt'] = len(index['notFound'])
            kv['index_first_missing_resources'] = [item['resource_id'] for item in
                                                   index['notFound'][0:min(len(index['notFound']), 20)]]
            kv['index_duplicates_cnt'] = len(index['duplicates'])
            kv['index_first_duplicates'] = index['duplicates'][0:min(len(index['duplicates']), 20)]
            kv['index_folders_not_trash'] = index['folders_not_trash']
            kv['index_files_not_trash'] = index['files_not_trash']
            kv['index_images_not_trash'] = index['images_not_trash']
            kv['index_videos_not_trash'] = index['videos_not_trash']
            kv['index_folders_trash'] = index['folders_trash']
            kv['index_files_trash'] = index['files_trash']
            photoslice = check_data.get('photoslice')
            kv['photoslice_fast_move_and_not_coincide'] = photoslice['fast_move_and_not_coincide']
            kv['photoslice_total'] = photoslice['not_fast_moved']['total']
            kv['photoslice_total_last_month'] = photoslice['not_fast_moved']['total_last_month']
            kv['photoslice_fast_moved_total'] = photoslice['fast_moved']['total']
            producer = check_data.get('producer')
            kv['producer_actual_main'] = len(producer['actual_main'])
            kv['producer_actual_reindex'] = len(producer['actual_reindex'])
            kv['producer_actual_main_not_reindex'] = producer['actual_main_not_reindex']
            retries = 0
            while retries < 5:
                try:
                    if 'disk_search_need_status' in issue.tags:
                        issue.update(tags={'remove': ['disk_search_need_status']})
                    issue.comments.create(text=support_comment_text.format(**kv))
                    break
                except:
                    traceback.print_exc()
                    retries += 1
                    time.sleep(retries * 2)
            return HttpResponse(status=200, content='Ok')
        except:
            traceback.print_exc()
            return HttpResponse(status=400, content='Error')

    return print_index_status_in_ticket(project, ticket, uid)



@csrf_exempt
def api_reindex_from_ticket_start(request, project):
    # Called from DISKSUP queue
    uid, ticket, tags = parse_startrek_notification(request)
    if not ticket:
        return HttpResponse(status=404, content='Failed to parse ticket')

    issue = None
    try:
        issue = st_client.issues[ticket]
    except:
        traceback.print_exc()

    if not issue:
        return HttpResponse(status=404, content='Failed to find ticket ' + ticket)

    if not uid:
        ticket_fail(issue, text='Переиндексация в поиске не запущена, не найден uid в описании письма')
        return HttpResponse(status=404, content='Uid not to found in ticket ' + ticket)

    remove_tags = []
    smartcache = True
    reindex = False
    if not tags:
        tags = issue.tags

    log.info("Got uid {uid} ticket {ticket} tags {tags}".format(uid=uid, ticket=ticket, tags=tags))
    if DISK_SMARTCACHE_TAGS[0] in tags:
        remove_tags.append(DISK_SMARTCACHE_TAGS[0])
        smartcache = True
    for reindex_tag in DISK_REINDEX_TAGS:
        if reindex_tag in tags:
            reindex = True
            remove_tags.append(reindex_tag)

    if smartcache and not reindex:
        resp = launch_smartcache_update(project, uid)
        if resp.status_code > 299:
            return resp

        issue.update(tags={'remove': remove_tags})
        issue = st_client.issues[issue.key]
        issue.comments.create(text='Smartcache обновлен для {uid}'.format(uid=uid))
        return resp

    if UserReindexation.objects.filter(ticket=ticket, status='STARTED').exists():
        ticket_fail(issue, text='Переиндексация в поиске уже запущена для этого тикета')
        return HttpResponse(status=202, content='Already exists')

    ur = UserReindexation.objects.filter(uid=uid, status='STARTED').first()
    if ur:
        if ur.reindex_date_start and ur.reindex_date_start is datetime.datetime:
            start_date = ur.reindex_date_start.isoformat()
        else:
            start_date = 'Unknown'

        ticket_fail(issue, text='Переиндексация в поиске уже запущена для этого пользователя {uid} запущена {start_date} '.format(uid=uid, start_date=start_date))
        return HttpResponse(status=202, content='Already exists')
    # make commit to database
    status, resp = do_launch_disk_reindex(project, uid, User.objects.get(username='mailsearch_admin'), ticket, smartcache, True, remove_tags)
    if status != 'OK':
        ticket_fail(issue, 'Переиндексация в поиске для пользователя {uid} не запущена, ошибка запуска'.format(uid=uid))
        return HttpResponse(status=500, content='Failed to launch for ' + ticket)

    issue.comments.create(text='Переиндексация в поиске запущена для пользователя {uid}'.format(uid=uid))
    log.info("Reindexation in disk started for ticket {ticket} for uid {uid}".format(uid=uid, ticket=ticket))
    return HttpResponse(status=200, content='OK')


def api_reindex_complete(request, project):
    uid = request.GET.get('uid')
    request_id = request.GET.get('rid')
    hard = request.GET.get('hard', 'False')
    smartcache = request.GET.get('smartcache', 'False')
    tags = request.GET.get('tags', ','.join(DISK_REINDEX_TAGS)).split(',')
    if not uid or not request_id:
        return HttpResponse(status=400, content='No uid or rid param')

    log.info("Reindexation disk completed {req_id} for uid {uid}".format(uid=uid, req_id=request_id))
    ur = UserReindexation.objects.get(id=request_id)
    if int(ur.uid) != int(uid):
        return HttpResponse(status=400, content='Bad user, expecting ' + ur.uid)

    if ur.status == 'COMPLETED':
        return HttpResponse(status=200, content='User already done')

    if ur.ticket:
        issue = st_client.issues[ur.ticket]

        # we completed in pssup queue, lets update index status in ticket
        if str(issue.key).startswith('PSSUP-'):
            if smartcache:
                resp = launch_smartcache_update(project, uid)
                if resp.status_code > 299:
                    return resp

            resp = print_index_status_in_ticket(project, ur.ticket, uid)
            if resp.status_code > 299:
                return resp

        if issue and issue.tags:
            remove_tags = []
            for tag in tags:
                if tag in issue.tags:
                    remove_tags.append(tag)
            issue.update(tags={'remove': remove_tags})
            issue = st_client.issues[issue.key]
            issue.comments.create(
                text='Переиндексация завершена для пользователя {uid} фотосрез {smartcache} hard {hard}'.format(
                    uid=ur.uid,
                    smartcache=smartcache,
                    hard=hard))

    ur.status = 'COMPLETED'
    ur.reindex_date_end = datetime.datetime.now()
    ur.save()

    return HttpResponse(status=200)

@login_required
def geo_list(request, project):
    proxy_host = DISK_HOSTS[project]['proxy_host']
    uid = request.GET.get('uid', '')
    json_resp = request.GET.get('json', '')
    coordinates = request.GET.get('coordinates', '')
    maxdistance = request.GET.get('maxdistance', '')
    i2trequest = request.GET.get('i2t_request', '')
    dssm_min_score = request.GET.get('dssm_min_score', '')
    start_time_orig = request.GET.get('time_start', '')
    end_time_orig = request.GET.get('time_end', '')
    length = request.GET.get('length', '20')
    start_time = start_time_orig
    end_time = end_time_orig
    invalid = ''
    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    linked_uids = set()
    for linkedacc in linked:
        linked_uids.add(str(linkedacc.uid))

    images = {}
    if uid:
        if uid not in linked_uids and not request.user.is_superuser:
            return HttpResponse(status=403, content='Not allowed')

        uri = proxy_host + '/api/geo/org_photos?&uid={uid}'.format(uid=uid)
        options_used = False
        if coordinates:
            split = coordinates.split(',')
            try:
                lat = float(split[0].strip())
                lon = float(split[1].strip())
                if maxdistance:
                    maxdistance = int(maxdistance)
                    uri += "&max-distance=" + str(maxdistance)

                uri += "&latitude=" + str(lat) + "&longitude=" + str(lon)
                options_used = True
            except:
                invalid = 'Invalid coordinates'

        if i2trequest:
            uri += "&text=" + i2trequest.strip()
            if dssm_min_score:
                try:
                    dssm_min_score = int(dssm_min_score)
                    uri += "&dssm_threshold=" + str(dssm_min_score)
                except:
                    invalid = "Dssm score должен быть число"

            options_used = True

        if start_time:
            if not end_time:
                end_time = int(time.time())
            else:
                try:
                    end_time = int(end_time)
                except:
                    try:
                        end_time = int(time.mktime(datetime.datetime.strptime(end_time, '%d.%m.%y %H:%M:%S').timetuple()))
                    except:
                        invalid = 'Invalid end time expecting epoch seconds or 18.03.21 20:39:00'

            try:
                start_time = int(start_time)
            except:
                try:
                    start_time = int(time.mktime(datetime.datetime.strptime(start_time, '%d.%m.%y %H:%M:%S').timetuple()))
                except:
                    invalid = 'Invalid start time expecting epoch seconds or 18.03.21 20:39:00'

            uri += '&time_start={start}&time_end={end}'.format(start=start_time, end=end_time)
            options_used = True


        try:
            length = int(length)
            uri += "&length=" + str(length)
        except:
            invalid = "Длина должна быть положительным числом"

        if not options_used:
            invalid = "Нужно выбрать один или несколько параметров время/координаты/ключевые слова"

        if not invalid:
            log.warn(proxy_host + ' ' + uri)
            response = requests.get(uri)
            if response.status_code != 200:
                invalid = "Internal error"

            if response.status_code == 200:
                if json_resp:
                    return HttpResponse(status=200, content=response.content)
                results = response.json().get("response", {}).get("results", [])
                if results:
                    gallery = []
                    row = []
                    cnt = 0
                    for result in results:
                        for group in result.get("groups", []):
                            for document in group.get("documents", []):
                                row.append(document.get("properties", ""))

                                if len(row) >= 3:
                                    gallery.append(row)
                                    row = []

                    if row:
                        gallery.append(row)

                    images = gallery



    template = loader.get_template('disk/geo_org_sample.html')
    context = default_context(request, project)
    context.update({
        'uid': uid,
        'linked': linked,
        'length': length,
        'images': images,
        'invalid': invalid,
        'time_start': start_time_orig,
        'time_end': end_time_orig,
        'i2t_request': i2trequest,
        'dssm_min_score': dssm_min_score,
        'maxdistance': maxdistance,
        'coordinates': coordinates
    })

    return HttpResponse(template.render(context, request))

@staff_member_required
def faces(request, project):
    proxy_host = DISK_HOSTS[project]['proxy_host']
    face_queue = DISK_HOSTS[project]['face_out_queue']
    uid = request.GET.get('uid', '')
    show_non_cluster = request.GET.get('show_non_cluster', 'false')
    faces_base_uri = request.GET.get('proxy_uri', proxy_host + '/sequential/search?')
    cluster_show_limit = int(request.GET.get('cluster_show_limit', 5))
    cluster_faces_load_limit = int(request.GET.get('cluster_faces_load_limit', 100))
    cluster = request.GET.get('cluster', '')

    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    linked_uids = set()
    for linkedacc in linked:
        linked_uids.add(linkedacc.uid)

    if not uid and linked_uids:
        uid = str(list(linked_uids)[0])

    clustered_faces = {}
    nonclustred_faces = []
    deleted = 0
    in_clustres = 0

    def load_faces(text):
        faces_uri = faces_base_uri + "&prefix={uid}&service={face_queue}&text={text}&get=*,-face_vector&&dp=left_join(face_resource_id,resource_id,,stid+stid,preview_stid+preview_stid,key+key)&length={length}"
        faces_resp = requests.get(
            faces_uri.format(uid=str(uid), text='type:face+AND+face_cluster_id:' + item['facecluster_id'],
                             face_queue=str(face_queue),
                             length=cluster_faces_load_limit))

        return faces_resp

    if uid:
        face_text = 'type:face'
        cluster_text = 'type:face_cluster'
        if cluster:
            face_text += '+AND+face_cluster_id:' + cluster
            cluster_text += '+AND+facecluster_id:' + cluster
        elif show_non_cluster != 'true':
            face_text += '+AND+face_cluster_id:'

        clusters_uri = faces_base_uri + "&prefix={uid}&service={face_queue}&text={text}&get=*"
        clusters_resp = requests.get(clusters_uri.format(uid=str(uid), text=cluster_text, face_queue=str(face_queue)))

        if clusters_resp.status_code != 200:
            return HttpResponse(clusters_resp.status_code, clusters_resp.content)

        clusters = {}
        for item in clusters_resp.json()['hitsArray']:
            clusters[item['facecluster_id']] = item
            faces_resp = load_faces('type:face+AND+face_cluster_id:'+ item['facecluster_id'])
            if faces_resp.status_code != 200:
                return HttpResponse(faces_resp.status_code, faces_resp.content)

            in_clustres += int(faces_resp.json()['hitsCount'])
            for face in  faces_resp.json()['hitsArray']:
                face = dict(face)
                cluster_id = face.get('face_cluster_id', '')
                stid = face.get('stid', '')
                preview_stid = face.get('preview_stid', stid)
                if not stid:
                    deleted += 1
                    continue

                face['id'] = face['face_id'].replace(':', '_')
                face['link'] = '/ui/' + project + '/disk/resource/preview?&stid=' + preview_stid + "&uid=" + str(
                    uid)
                face['altlink'] = '/ui/' + project + '/disk/resource/preview?&stid=' + stid + "&uid=" + str(uid)

                if cluster_id:

                    if cluster_id not in clustered_faces:
                        clustered_faces[cluster_id] = {'cluster_id': cluster_id, 'cluster': clusters[cluster_id],
                                                       'faces': [], 'faces_cnt': int(faces_resp.json()['hitsCount']),
                                                       'name': clusters[cluster_id].get('face_cluster_suggest_name' , ''),
                                                       'names': clusters[cluster_id].get('face_cluster_suggest_names' , '')}

                    if len(clustered_faces[cluster_id]['faces']) > cluster_faces_load_limit:
                        continue

                    clustered_faces[cluster_id]['faces'].append(face)


    if show_non_cluster == 'true':
        faces_resp = load_faces('type:face+AND+NOT+face_cluster_id:*')
        if faces_resp.status_code != 200:
            return HttpResponse(faces_resp.status_code, faces_resp.content)
        for face in faces_resp.json()['hitsArray']:
            face = dict(face)
            stid = face.get('stid', '')
            preview_stid = face.get('preview_stid', stid)
            if not stid:
                deleted += 1
                continue

            face['id'] = face['face_id'].replace(':', '_')
            face['link'] = '/ui/' + project + '/disk/resource/preview?&stid=' + preview_stid + "&uid=" + str(
                uid)
            face['altlink'] = '/ui/' + project + '/disk/resource/preview?&stid=' + stid + "&uid=" + str(uid)

            nonclustred_faces.append(face)

    clustered_faces_sorted = OrderedDict()
    clusters_list = list(clustered_faces.values())
    clusters_list = sorted(clusters_list, key=lambda x: -x['faces_cnt'])
    for item in clusters_list:
        clustered_faces_sorted[item['cluster_id']] = item

    template = loader.get_template('disk/face.html')
    context = default_context(request, project)
    context.update({
        'nonclustred_faces': nonclustred_faces,
        'clustered_faces': clustered_faces_sorted,
        'faces_in_clusters': in_clustres,
        'deleted': deleted,
        'uid': uid,
        'linked': linked,
        'clustered_show_limit': cluster_show_limit
    })

    return HttpResponse(template.render(context, request))

@user_passes_test(check_user_disk_manager)
def video_beauty_list(request, project):
    result = []
    total_by_filter = 0
    total_video = 0
    algorythms = [
        {'name': 'fixed_interval_2', 'description': 'Фикс 2 секунд', 'selected': False},
        {'name': 'fixed_interval_5', 'description': 'Фикс 5 секунд', 'selected': False},
        {'name': 'fixed_interval_8', 'description': 'Фикс 8 секунд', 'selected': False},
        {'name': 'avapreview', 'description': 'Ava Preview', 'selected': False},
    ]
    uid = request.GET.get('uid', default='')
    algorythm_param = request.GET.get('algorythm', 'fixed_interval_2')
    if algorythm_param and algorythm_param.startswith('fixed_interval_'):
        interval = str(algorythm_param)[len('fixed_interval_'):]
        algorythm = 'fixed_interval+AND+split_interval:interval_value_' + interval
    else:
        algorythm = algorythm_param

    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    linked_uids = set()
    for linkedacc in linked:
        linked_uids.add(linkedacc.uid)

    if not uid and linked_uids:
        uid = str(list(linked_uids)[0])
    default_cost_disk_aethetic = 0.0
    default_add_filters = 'mobile_porn <= 0.37; binary_porn <= 0.86; gruesome <= 0.85'
    cost_disk_aethetic = request.GET.get('cost_disk_aethetic', default=default_cost_disk_aethetic)
    addfilters = request.GET.get('additional_filters', default=default_add_filters)
    if uid:
        if not request.user.is_superuser and int(uid) not in linked_uids:
            return HttpResponse(status=403, content='Not allowed')

        search_req = VIDEO_PREVIEWS_API_LUCENE_HOST
        search_req += '/search?prefix=' + uid
        search_req += '&get=*&text=uid:' + uid
        search_req += '+AND+algorythm:' + str(algorythm) + '&sort=cost_disk_aethetic_0'

        search_req += '&postfilter=cost_disk_aethetic_0+%3E%3D+' + str(cost_disk_aethetic)
        #search_req += '&length=' + str(length)
        if addfilters:
            for filter in addfilters.split(';'):
                search_req += "&" + urllib.urlencode({'postfilter': str(filter).strip()})

        resp = requests.get(search_req)
        if resp.status_code != 200:
            return HttpResponse(resp.status_code, resp.content)
        data = resp.json()
        i = 1
        total_by_filter = int(data['hitsCount'])

        for item in data['hitsArray']:
            doc = dict(item)
            doc['number'] = i
            #doc['preview'] = '/disk/video/beauty/preview/tmpdir/' + doc['stid'].replace('.', '_') + '/preview_1.png'
            doc['preview'] = '/disk/video/beauty/preview/tmpdir/' + doc['stid'].replace('.', '_') + '/preview_1.png'
            doc['video_link'] = '/ui/' + project + '/disk/video/beauty/video?&stid=' + doc['stid']
            i += 1

            result.append(doc)

        search_req = VIDEO_PREVIEWS_API_LUCENE_HOST
        search_req += '/search?prefix=' + uid
        search_req += '&get=*&length=1&text=uid:' + uid
        resp = requests.get(search_req)
        data = resp.json()
        if resp.status_code != 200:
            return HttpResponse(resp.status_code, resp.content)

        total_video = int(data['hitsCount'])

    if not algorythm_param:
        algorythms[0]['selected'] = True
    else:
        for a in algorythms:
            if a['name'] == algorythm_param:
                a['selected'] = True

    template = loader.get_template('disk/video_beauty_list.html')
    context = {
        'user': request.user,
        'webtools_projects': [DISK_PROJECTS_GROUP],
        'webtools_project': WEBTOOLS_MODULES[project],
        'webtools_project_id': project,
        'videos': result,
        'total_video': total_video,
        'total_by_filter': total_by_filter,
        'cost_disk_aethetic': cost_disk_aethetic,
        'additional_filters': addfilters,
        'algorythms': algorythms,
        'uid': uid if uid or not linked else linked[0].uid,
        'linked': linked,
        'page_size': 50
    }

    return HttpResponse(template.render(context, request))

@user_passes_test(check_user_disk_manager)
def get_video(request, project):
    stid = request.GET.get('stid')
    url = 'http://storage.mail.yandex.net:10010/gate/get/' + stid
    resp = requests.get(url, stream=True)

    response = StreamingHttpResponse(
        (chunk for chunk in resp.iter_content(512 * 1024)),
        content_type='application/octet-stream')
    return response

@login_required
def get_preview_with_check(request, project):
    stid = request.GET.get('stid')
    uid = request.GET.get('uid')
    proxy_host = DISK_HOSTS[project]['proxy_host']
    if not request.user.is_superuser:
        linked = LinkedYandexUser.objects.filter(user=request.user).all()
        linked_uids = set()
        for linkedacc in linked:
            linked_uids.add(str(linkedacc.uid))

        if uid not in linked_uids:
            return HttpResponse(status=403, content="Not allowed for user to access " + uid)

    resp = requests.get(proxy_host + '/sequential/search?prefix={uid}&text=stid:{stid}+OR+preview_stid:{stid}&get=id&service=disk_queue'.format(uid=uid, stid=str(stid).replace(':', '\\:')))
    if resp.status_code != 200 or int(resp.json()['hitsCount']) < 0:
        return HttpResponse(status=403, content="Not allowed for user to access stid " + stid)

    ava_url = DISK_HOSTS[project]['ava_host'] + '/get-disk/{uid}/{hash}/1280_nocrop'
    mds_url = DISK_HOSTS[project]['storage_host'] + '/gate/get/{stid}'

    if str(stid).startswith('ava'):
        stidsplit = stid.split(':')
        url = ava_url.format(uid=stidsplit[2], hash=stidsplit[3])
    else:
        url = mds_url.format(stid=stid)

    resp = requests.get(url, stream=True)

    response = StreamingHttpResponse(
        (chunk for chunk in resp.iter_content(512 * 1024)),
        content_type='application/octet-stream')
    return response


@user_passes_test(check_user_disk_manager)
def get_preview(request, project):
    stid = request.GET.get('stid')
    uid = request.GET.get('uid')
    ava_url = DISK_HOSTS[project]['ava_host'] + '/get-disk/{uid}/{hash}/1280_nocrop'
    mds_url = DISK_HOSTS[project]['storage_host'] + '/gate/get/{stid}'

    if str(stid).startswith('ava'):
        stidsplit = stid.split(':')
        url = ava_url.format(uid=stidsplit[2], hash=stidsplit[3])
    else:
        url = mds_url.format(stid=stid)

    resp = requests.get(url, stream=True)

    response = StreamingHttpResponse(
        (chunk for chunk in resp.iter_content(512 * 1024)),
        content_type='application/octet-stream')
    return response

@user_passes_test(check_user_disk_manager)
def video_beauty_result(request, project):
    stid = request.GET.get('stid')
    path = request.GET.get('path')
    uid = request.GET.get('uid')
    fixed_interval_value = request.GET.get('fixed_interval_value')
    if uid:
        uid = int(uid)

    image_table = []
    graphs = OrderedDict()
    graphs_table = []
    data = {}
    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    #
    if request.user.is_superuser:
        linked_count = len(linked)
        if linked_count > 0:
            linked = linked[linked_count - 1].uid
        else:
            linked = ''

    if not stid and uid and path:
        if not request.user.is_superuser and uid not in linked:
            return HttpResponse(status=403, content='You are not allowed to do this')
        path = path.strip().replace(' ', '\\ ')
        disk_proxy_host = 'man1-7315-disksearch-yadisk-proxy-19502.gencfg-c.yandex.net:19502'
        disk_search_uri = 'http://{host}/sequential/search?service=disk_queue&text=key:{key}&get=stid&prefix={uid}'
        disk_search_uri = disk_search_uri.format(key=urllib.quote_plus(path), uid=uid, host=disk_proxy_host)
        print 'Resolving', path, uid, disk_search_uri
        resp = requests.get(disk_search_uri)
        if resp.status_code != 200:
            return HttpResponse(resp.status_code, resp.content)
        stids = resp.json()
        if stids['hitsCount'] > 0:
            stid = stids['hitsArray'][0]['stid']
            print uid, path, 'Resolved into', stid

    if stid and request.user.is_superuser:
        params = request.GET.copy()
        params['stid'] = stid
        resp = requests.get(VIDEO_PREVIEWS_API_HOST + '/process?' + params.urlencode())
        if resp.status_code != 200:
            return HttpResponse(resp.status_code, resp.content)
        data = resp.json()

        row = []
        cnt = 0
        for item in data.get('files', []):
            link = item.get('file', '')
            preview_metrics = item.get('metrics',  {})
            for k, v in preview_metrics.iteritems():
                if k not in graphs:
                    graphs[k] = str(v)
                else:
                    graphs[k] += ',' + str(v)

            metrics_str = ''
            for k, v in item.get('metrics', {}).iteritems():
                metrics_str += k + ' = ' + str(v) + '\n'

            split = link.strip().split('/')
            if len(split) > 1:
                name = split[-1]
            else:
                name = link.strip()
            row.append({'link': '/disk/video/beauty/preview/' + link, 'id': cnt, 'name': name, 'title': metrics_str, 'metrics': item.get('metrics', {})})
            cnt += 1
            if cnt >= 4:
                image_table.append(row)
                row = []
                cnt = 0

        if row:
            image_table.append(row)

        graphs_table = []
        row = []
        cnt = 0
        for k, v in graphs.iteritems():
            row.append({'name': k, 'value': v})
            cnt += 1
            if cnt >= 4:
                graphs_table.append(row)
                row = []
                cnt = 0

        if row:
            graphs_table.append(row)
    else:
        data = {}

    if not uid and linked:
        uid = linked[0]

    template = loader.get_template('disk/video_beauty_result.html')
    context = {
        'user': request.user,
        'webtools_projects': [DISK_PROJECTS_GROUP],
        'webtools_project': WEBTOOLS_MODULES[project],
        'webtools_project_id': project,
        'previews': image_table,
        'linked_uids': linked,
        'metrics': data,
        'stid': stid if stid else '',
        'uid': uid if uid else '',
        'fixed_interval_value': fixed_interval_value if fixed_interval_value else 5,
        'path': path if path and not stid else '',
        'project_queues': [],
        'graphs': graphs_table
    }

    return HttpResponse(template.render(context, request))

@user_passes_test(check_user_disk_manager)
def reindex_template(request, project):
    if project not in WEBTOOLS_PROJECTS:
        return HttpResponseServerError('Project not found ' + project)

    offset = request.GET.get('offset', 0)
    limit = request.GET.get('limit', 40)
    reindexations = UserReindexation.objects.filter(component=project).order_by('-reindex_date_start')[offset:limit]


    template = loader.get_template('disk/reindex.html')

    if not request.user.is_active or not request.user.is_staff:
        if project not in DISK_ALLOWED_PROJECTS:
            return HttpResponseServerError('Project access forbidden ' + project)

        context = {
            'user': request.user,
            'webtools_projects': [DISK_PROJECTS_GROUP],
            'webtools_project': WEBTOOLS_MODULES[project],
            'webtools_project_id': project,
            'history': reindexations,
            'subservices': ['disk', 'face'],
            'project_queues': [],
        }
    else:
        context = {
            'history': reindexations
        }
        context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


