# -*- coding: utf-8 -*-
import json
import urllib

import requests
from django.contrib.admin.views.decorators import staff_member_required
from django.contrib.auth.decorators import user_passes_test
from django.http import HttpResponse, HttpResponseServerError
from django.template import loader

from mail_search_webtools.settings import WEBTOOLS_MODULES
from webtools.views_utils import default_context

MESSENGER_SUGGEST_URI = ''

# move it to settings.py
MESSENGER_SUGGEST_HOST = 'messenger-search-proxy-prod-qa-1.sas.yp-c.yandex.net:80'

def user_in_group(user, group):
    return user.groups.filter(name=group).exists()

def check_user_messenger_manager(user):
    return user.is_active and (user.is_superuser or user_in_group(user, 'messenger_manager'))

@staff_member_required
def suggest_api(request, project):
    uid = request.GET.get('uid')
    query = request.GET.get('query')
    uri = MESSENGER_SUGGEST_HOST
    limit = 5

    query = urllib.quote_plus(query.encode('utf-8'))
    uri += MESSENGER_SUGGEST_URI.format(uid=uid, query=query, limit=limit)

    resp = requests.get(uri)
    if resp.status_code != 200:
        return HttpResponse(resp.status_code, resp.content)

    data = resp.json()
    # convert data in array if needed
    #
    return HttpResponse(json.dumps(data))

@staff_member_required
def suggest_template(request, project):
    template = loader.get_template('messenger/suggest.html')

    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError(project + ' not found')

    context = {
        'request_text': request.GET.get('request_text', ''),
        'suggest_display_field': 'text'
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


@user_passes_test(check_user_messenger_manager)
def recommended_users_template(request, project):
    template = loader.get_template('messenger/recommended_users.html')

    guid = request.GET.get('guid', '')
    additional_params = request.GET.get('additional_params', '')
    items = []
    if guid:

        query = '/api/search/messenger/recents?length=20&guid=' + guid
        if additional_params:
            query += '&ranking=' + urllib.quote_plus(additional_params.encode('utf-8'))

        #uri = MESSENGER_SUGGEST_HOST
        #query = urllib.quote_plus(query.encode('utf-8'))

        resp = requests.get('http://' + MESSENGER_SUGGEST_HOST + query)
        if resp.status_code != 200:

            return HttpResponse(resp.status_code, resp.content)

        items = resp.json()['recents']

    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError(project + ' not found')

    context = {
        'additional_params': additional_params,
        'items': items,
        'guid': guid
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))
