# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import datetime
from django.contrib.auth.models import User
from django.core.validators import MaxValueValidator, MinValueValidator
from django.db import models

# Create your models here.


class LinkedYandexUser(models.Model):
    user = models.ForeignKey(User)
    uid = models.BigIntegerField(unique=True)
    login = models.CharField(max_length=40)
    first_name = models.CharField(max_length=40, default='Безымянный')
    last_name = models.CharField(max_length=40, default='')
    email = models.CharField(max_length=40, default='')

    class Meta:
        verbose_name = "Привязанный аккаунт"
        verbose_name_plural = "Привязанные аккаунты"

    def __unicode__(self):
        return unicode(self.user.username) + ' ' + unicode(self.email)


USER_REINDEX_STATUSES = (('INIT', 'Не отправлена'), ('STARTED', 'Отправлен'), ('COMPLETED', 'Переиндексирован'))
class UserReindexation(models.Model):
    uid = models.BigIntegerField(verbose_name='UID')
    user = models.ForeignKey(User)
    component = models.CharField(max_length=100, verbose_name='модуль')
    ticket = models.CharField(max_length=30, verbose_name='тикет', default='')
    subservice = models.CharField(max_length=100, verbose_name='сабсервис', default='')
    reindex_date = models.DateTimeField(verbose_name='Время начала переиндексации', default=datetime.datetime.now())
    status = models.CharField(choices=USER_REINDEX_STATUSES, max_length=100, verbose_name='Статус', default='INIT')
    reindex_date_start = models.DateTimeField(verbose_name='Время начала переиндексации', default=datetime.datetime.now())
    reindex_date_end = models.DateTimeField(verbose_name='Время конца переиндексации', null=True, blank=True)

    class Meta:
        verbose_name = "Реиндексация пользователя"
        verbose_name_plural = "Реиндексации пользователей"

    def __unicode__(self):
        return unicode(self.uid)


COPY_JOB_STATUSES = (('CREATED', 'Создана'), ('CREATION_FAILED', 'Ошибка создания'), ('RUNNING', 'Копируется'), ('FINISHED', 'Завершено'), ('REMOVED', 'Удалено'))


class ManualCopyJob(models.Model):
    user = models.ForeignKey(User)
    dest_host = models.CharField(verbose_name='Хост консьюмер', max_length=200)
    start_date = models.DateTimeField(verbose_name='Время создания', default=datetime.datetime.now())
    finish_date = models.DateTimeField(verbose_name='Время завершения', default=datetime.datetime.now())
    status = models.CharField(verbose_name='Статус', choices=COPY_JOB_STATUSES, max_length=200)
    service = models.CharField(verbose_name='Сервис', max_length=200)
    start_shard = models.IntegerField()
    dump_port = models.IntegerField()
    search_port = models.IntegerField()
    index_port = models.IntegerField()
    end_shard = models.IntegerField()
    lock_index = models.BooleanField()
    copy_urls = models.CharField(max_length=1000)
    disable_indexing = models.BooleanField()
    replace = models.BooleanField()
    check_dups = models.BooleanField()
    timeout = models.IntegerField()
    max_threads = models.IntegerField()
    retry_count = models.IntegerField()
    sharding_fields = models.CharField(max_length=400)
    job_type = models.CharField(default='CopyJob', max_length=200)


DROP_SHARD_STATUS = (('ERROR', 'Ошибка'), ('OK', 'OK'), ('WARNING', 'Предупреждение'))


class LuceneDropShard(models.Model):
    user = models.ForeignKey(User)
    drop_date = models.DateTimeField(verbose_name='Время дропа', default=datetime.datetime.now())
    shard = models.IntegerField(verbose_name='Шард [0-65534)', validators=[MaxValueValidator(65533), MinValueValidator(0)])
    lucene_shard = models.IntegerField(verbose_name="Люценовский шард", default=-1)
    host = models.CharField(verbose_name='Хост', max_length=200)
    component = models.CharField(max_length=100, verbose_name='модуль')
    status = models.CharField(choices=DROP_SHARD_STATUS, max_length=100, verbose_name='Статус', default='ERROR')

    class Meta:
        verbose_name = "Дроп шарда люцены"
        verbose_name_plural = "Дропы шардов люцены"

    def __unicode__(self):
        return unicode(self.host) + ':' + unicode(self.lucene_shard) + ':' + unicode(self.shard)
