# -*- coding: utf-8 -*-
from __future__ import absolute_import

import argparse
import urllib2
import json
import os
import time

from PIL import Image, ImageFont, ImageDraw

from mail_search_webtools.webtools_modules import WEBTOOLS_PROJECTS

HOST_ANSWER_TIMEOUT = 31
URLLIB_ANSWER_TIMEOUT = 10
SLEEP = 2
TRIES = 2

searchmap_manual = False

# searchmap_manual="http://cmsearch.yandex.ru/res/gencfg/stable-100-r36/generated/lucene/mail.cfg"


def make_auth_req(url, token=None):
    request = urllib2.Request(url)
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=20)
            break
        except Exception as e:
            attempts += 1
            print("Error reached {0} Retry count:{1} Url: {2}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.read()


def parse_json(data):
    return json.loads(data)


def parse_searchmap_line(line):
    sep = str(line).index(' ')
    if sep <= 0 or sep >= len(line) - 1:
        return None, None

    queue_names = line[:sep].split(',')
    row = line[sep+1:]
    result = {}
    for part in row.split(','):
        part = part.strip()
        if not part:
            continue

        if part.startswith('iNum:'):
            result['iNum'] = part[5:]
        elif part.startswith('zk:'):
            result['zk'] = part[3:]
        elif part.startswith('shards:'):
            result['shards'] = part[7:]
        elif part.startswith('host:'):
            result['host'] = part[5:]
        elif part.startswith('tag:'):
            result['tag'] = part[4:]
        elif part.startswith('json_indexer_port:'):
            result['index_port'] = part[18:]
        elif part.startswith('search_port_ng:'):
            result['search_port_ng'] = part[15:]
        elif part.startswith('search_port:'):
            result['search_port_old'] = part[12:]

    return queue_names, result

def get_searchmap_parsed_fromfile(searchmap_path):
    """
    :param searchmap_url:string
    :return: list[dict[service][iNum][{host:port},{host2:port2}...],dict[service2][iNum2][{host:{port}, {host2:port2}..]]
    """
    print searchmap_path

    with open(searchmap_path, 'r') as out:
        searchmap_unparsed = out.readlines()

    return_dict = {}
    for line in searchmap_unparsed:
        if not line or not line.strip():
            continue
        if line.startswith("#"):
            continue
        # Get iNum
        services, row = parse_searchmap_line(line)
        if not services or not row:
            print 'Skipping bad fromatted line', line
            continue

        for service in services:
            if not return_dict.get(service):
                return_dict[service] = {}

            iNum = row.get('iNum')
            if not iNum:
                print 'Skipping no iNum', line
                continue

            search_port_old = row.get('search_port_old', None)
            search_port = row.get('search_port_ng', search_port_old)
            if not search_port:
                print 'Skipping no search port', line
                continue

            zk = row.get('zk')
            if not zk:
                print 'Skipping no zk', line
                continue

            shards = row.get('shards')
            if not shards:
                print 'No shards', line
                continue

            host = row.get('host')
            if not host:
                print 'No host', line
                continue

            # create new key if it didnt exists
            if not return_dict[service].get(iNum):
                return_dict[service][iNum] = []
            return_dict[service][iNum].append({host: search_port,
                                               "host": host,
                                               "zk": zk, "hostname": "{0}:{1}".format(host, search_port),
                                               "shards": shards})
    return return_dict


def generate_uniq_hostlist(searchmap_parsed):
    uniq_hostlist = []
    for service, data in searchmap_parsed.iteritems():
        for iNum, hostlist in data.iteritems():
            for hostname in hostlist:
                if hostname not in uniq_hostlist:
                    uniq_hostlist.append(hostname)
    return uniq_hostlist


def get_json(filename):
    try:
        with open(filename, 'r') as f:
            return json.loads(f.readlines()[0])
    except IOError:
        return None


def get_uniq_zk_list(searchmap_parsed):
    zk_list = []
    for service, data in searchmap_parsed.iteritems():

        for inum, hostlist in data.iteritems():
            for hostdata in hostlist:
                zk_list.append(hostdata['zk'])

    return set(zk_list)


def get_queuelen_dict(zk_uniq_urls):
    queuelen_d = {}

    for queue_desc in zk_uniq_urls:
        # sas1-5867.search.yandex.net:17973/17974|man1-6451.search.yandex.net:17973/17974|myt1-0441.search.yandex.net:17973/17974|man1-7014.search.yandex.net:17973/17974|sas1-8532.search.yandex.net:17973/17974|man1-7336.search.yandex.net:17973/17974|myt1-0693.search.yandex.net:17973/17974|sas1-7201.search.yandex.net:17973/17974|myt1-0541.search.yandex.net:17973/17974

        for zoolooser_head in queue_desc.split("|"):
            try:
                port = zoolooser_head.split("/")[1]
                host = zoolooser_head.split(":")[0]
                print "Queuelen request url: http://{0}:{1}/queuelen".format(host, port)
                url = "http://{0}:{1}/queuelen".format(host, port)
                req = make_auth_req(url, token=None)
            except Exception as e:
                print "Exception reached when trying to get queuelen from zookeeper {0} Try next head.".format(
                    zoolooser_head)
                continue
            break

        #        port = queue_desc.split("|")[2].split("/")[1]
        #        host = queue_desc.split("|")[2].split(":")[0]
        #        print "Queuelen request url: http://{0}:{1}/queuelen".format(host, port)
        #        url = "http://{0}:{1}/queuelen".format(host, port)
        #        req=make_auth_req(url, token=None)

        for queuelen_line in req.splitlines():
            service_name_q = queuelen_line.split("\t")[0]
            service_shard_q = queuelen_line.split("\t")[1]
            service_hostname_q = queuelen_line.split("\t")[2]
            service_queuelen_q = queuelen_line.split("\t")[3]
            service_positiontime_lag_q = queuelen_line.split("\t")[7]

            if not queuelen_d.get(service_name_q, False):
                queuelen_d[service_name_q] = {}
            if not queuelen_d[service_name_q].get(service_shard_q):
                queuelen_d[service_name_q][service_shard_q] = {}

            queuelen_d[service_name_q][service_shard_q][service_hostname_q] = [service_queuelen_q,
                                                                               service_positiontime_lag_q]
    return queuelen_d


def redYellowGreen(value_raw):
    if value_raw == "False":
        return ((int(0), int(0), int(255)))

    value = int(value_raw)
    max = 1000
    if value > max:
        value = max
    if value < 0:
        value = 0

    green_max = 255
    red_max = 255
    red = 0
    green = 0
    blue = 0

    if value < max / 2:
        green = green_max
        red = round((value / (max / 2.0)) * green_max)
    else:
        red = red_max
        green = round((1.0 - ((value - (max / 2.0)) / (max / 2.0))) * red_max)
    return (int(red), int(green), int(blue))


def update(searchmap_file, output_folder):
    searchmap_parsed = get_searchmap_parsed_fromfile(searchmap_file)

    print("Done")

    zk_uniq_urls = get_uniq_zk_list(searchmap_parsed)
    print "ZkUrls", '\n'.join(zk_uniq_urls)
    queuelen_dict = get_queuelen_dict(zk_uniq_urls)
    print("Getting queuelen is done. Filter hosts now.")

    actual_hosts = {}
    for service, data in searchmap_parsed.iteritems():
        if service in ["the_messenger", "pg"]:
            continue
        actual_hosts[service] = {}
        for inum, hostlist in data.iteritems():
            for hostdata in hostlist:
                shard_list = hostdata["shards"].split("-")
                for shard_num in range(int(shard_list[0]), int(shard_list[1]) + 1):
                    if not actual_hosts[service].get(str(shard_num), False):
                        actual_hosts[service][str(shard_num)] = []

                    queuelen_dict_c = queuelen_dict[service].get(str(shard_num), {})
                    actual_hosts[service][str(shard_num)].append(
                        [queuelen_dict_c.get(hostdata['host'], ["False", "False"])[0],
                         queuelen_dict_c.get(hostdata['host'], ["False", "False"])[1],
                         hostdata['hostname'],
                         inum])

    side = 4
    width_back = 3200
    height_back = 1400

    coords_dict = {}
    for service, data in actual_hosts.iteritems():
        if not data:
            print 'Skipping', service, 'no data'
            continue
        coords_dict[service] = {}

        # Move previous image to timestamp
        try:
            os.rename("{0}/{1}.json".format(output_folder, service),
                      "{0}/{1}_prev.json".format(output_folder, service))
        except Exception as e:
            print("Cannot move old file - first launch?:{0}".format(e))

        with open("{0}/{1}.json".format(output_folder, service), 'w+') as out:
            out.write(json.dumps(data))
            out.close()

        shard = 0
        im = Image.new('RGB', (width_back, height_back), (255, 255, 255))
        dr = ImageDraw.Draw(im)

        for h in xrange(0, width_back, side * 2):
            for w in xrange(0, height_back, side * 2):
                if shard > 65533:
                    break
                #            print shard
                curr_shard = data["{0}".format(shard)]
                replica_n = 0
                for r_h in xrange(0, side * 2, side):
                    for r_w in xrange(0, side * 2, side):
                        #                    print r_h+h,r_w+w,r_h+h+side,r_w+w+side
                        shard_data = False
                        if len(curr_shard) - 1 >= replica_n:
                            shard_data = curr_shard[replica_n][0]

                            coords_dict[service]["{0}_{1}".format((r_h + h) / side, (r_w + w) / side)] = [
                                shard,
                                replica_n,
                                curr_shard[replica_n][0],
                                curr_shard[replica_n][2],
                                curr_shard[replica_n][3]
                            ]
                        else:
                            coords_dict[service]["{0}_{1}".format((r_h + h) / side, (r_w + w) / side)] = [
                                shard,
                                replica_n,
                                "0",
                                "No Replica",
                                "0"
                            ]

                        dr.rectangle(((r_h + h, r_w + w), (r_h + h + side, r_w + w + side)),
                                     fill=redYellowGreen(shard_data), outline="white")

                        replica_n += 1
                shard += 1
            # Move previous image to timestamp
        try:
            os.rename("{0}/{1}.png".format(output_folder, service),
                      "{0}/{1}.png_prev".format(output_folder, service))
        except Exception as e:
            print("Cannot move old file - first launch?:{0}".format(e))
        im.save("{0}/{1}.png".format(output_folder, service))

        try:
            os.rename("{0}/{1}_{2}".format(output_folder, service, "coords.json"),
                      "{0}/{1}_{2}_prev".format(output_folder, service, "coords.json"))
        except Exception as e:
            print("Cannot move old file - first launch?:{0}".format(e))
        with open("{0}/{1}_{2}".format(output_folder, service, "coords.json"), 'w+') as out:
            out.write(json.dumps(coords_dict[service]))
            out.close()

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-o', '--output', help='Output path', dest='output_folder', required=True)
    args = parser.parse_args()
    for project_id, project in WEBTOOLS_PROJECTS.iteritems():
        output_dir = args.output_folder.rstrip('/') + '/' + project_id
        if not os.path.exists(output_dir):
            os.mkdir(output_dir)

        print 'Updating', project_id

        update(project['searchmap'], output_dir)


