# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
import json
import requests
from django.contrib.auth.decorators import user_passes_test
from django.http import HttpResponse
from django.template import loader

from mail_search_webtools.settings import PASSPORT_HOSTS
from webtools.views import default_context

log = logging.getLogger('django')


def user_in_group(user, group):
    return user.groups.filter(name=group).exists()

def check_user_passport_manager(user):
    manager_status = user.is_active and (user.is_superuser or user_in_group(user, 'passport_manager'))
    print 'Manager status', manager_status, user
    return user.is_active and (user.is_superuser or user_in_group(user, 'passport_manager'))


@user_passes_test(check_user_passport_manager)
def squatter_phone(request, project):
    backend_host = PASSPORT_HOSTS[project]['squatter_backend']
    url = 'http://{backend}/search?text=id:phone_{phone}&get=*'
    phone = request.GET.get('phone', '')
    phone_info = None
    if phone:
        resp = requests.get(url.format(backend=backend_host, phone=phone.strip().strip('+')))
        if resp.status_code != 200:
            return HttpResponse(resp.status_code, resp.content)
        hits = resp.json()['hitsArray']
        if hits:
            phone_info = json.dumps(hits[0])
        else:
            phone_info = json.dumps({'error': 'phone not found'})

    template = loader.get_template('passport/squatter.html')
    context = default_context(request, project)
    context.update({
        'phone_info': phone_info,
        'phone': phone,
        #'linked': linked,
    })

    return HttpResponse(template.render(context, request))
