# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import requests

from django.contrib.auth.decorators import login_required

from django.http import HttpResponse, HttpResponseServerError
from django.template import loader


# Create your views here.
from mail_search_webtools import settings
from mail_search_webtools.settings import WEBTOOLS_API_HOST, DEFAULT_YANDEX_USER, WEBTOOLS_MODULES
from webtools.models import LinkedYandexUser, UserReindexation
from webtools.views import default_context


def proxy_request(url):
    resp = requests.get(url, timeout=60)
    print url
    response = HttpResponse(resp.content, status=resp.status_code)
    for k, v in resp.headers.iteritems():
        response[k] = v

    return response


@login_required
def mail_search_snippet(request):
    template = loader.get_template('mail_search_snippet.html')
    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    #
    if request.user.is_superuser:
        linked_count = len(linked)
        if linked_count > 0:
            linked = linked[linked_count-1].uid
        else:
            linked = ''
    context = {
        'user': request.user,
        'linked_uids': linked,
        'modules': WEBTOOLS_MODULES,
        'base_template': 'base.html' if request.user.is_superuser else 'base-public.html'
    }

    return HttpResponse(template.render(context, request))


@login_required
def disk_search(request):
    if hasattr(request, 'user_created') and request.user_created:
        template = loader.get_template('greetings.html')

        context = {
            'yandex_login': request.user.login,
            'linked_accounts': ','.join(request.linked_accounts),
            'base_template': 'base.html' if request.user.is_superuser else 'base-public.html'
        }

        return HttpResponse(template.render(context, request))

    template = loader.get_template('disk_search.html')
    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    if request.user.is_superuser:
        linked_count = len(linked)
        if linked_count > 0:
            linked = linked[linked_count-1].uid
        else:
            linked = ''

    context = {
        'user': request.user,
        'linked_uids': linked
    }

    return HttpResponse(template.render(context, request))


@login_required
def mail_search_proxy(request):
    uid = request.GET['uid']
    if not request.user.is_superuser:
        linked = LinkedYandexUser.objects.filter(user=request.user, uid=uid).all()

        if not linked:
            return HttpResponse('Uid ' + uid + ' not found in your linked accounts', status=403)

    url = settings.WEBTOOLS_MSEARCH_PROXY
    url += '/api/async/mail/search?'
    url += request.GET.urlencode()
    url += '&nostore'

    return proxy_request(url)

@login_required
def iex_images_template(request):
    template = loader.get_template('iex_news_images.html')
    linked = LinkedYandexUser.objects.filter(user=request.user).all()

    if request.user.is_superuser:
        linked_count = len(linked)
        if linked_count > 0:
            linked = linked[linked_count-1].uid
        else:
            linked = ''
    #
    context = {
        'user': request.user,
        'linked_uids': linked,
        'modules': WEBTOOLS_MODULES,
        'base_template': 'base.html' if request.user.is_superuser else 'base-public.html'
    }

    return HttpResponse(template.render(context, request))


@login_required
def iex_images(request):
    uid = request.GET['uid']
    if not request.user.is_superuser:
        linked = LinkedYandexUser.objects.filter(user=request.user, uid=uid).all()

        if not linked:
            return HttpResponse('Uid ' + uid + ' not found in your linked accounts', status=403)

    url = settings.WEBTOOLS_API_HOST
    url += '/newsImages?'
    url += 'uid={uid}&search-filter={filter}&count={count}&first={first}&mdb=pg&request={text}'

    return proxy_request(url.format(
        uid=uid,
        text=request.GET['text'],
        filter=request.GET['filter'],
        first=request.GET['first'],
        count=request.GET['count']))


@login_required
def iex_snippet(request):
    template = loader.get_template('iex_snippet.html')

    context = {
        'user': request.user
    }

    return HttpResponse(template.render(context, request))


@login_required
def mail_search(request, project):
    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError("Project not found " + project)

    template = loader.get_template('mail/mail_search.html')
    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    #
    if request.user.is_superuser:
        linked_count = len(linked)
        if linked_count > 0:
            linked = linked[linked_count - 1].uid
        else:
            linked = ''
    context = {
        'user': request.user,
        'linked_uids': linked,
        'modules': WEBTOOLS_MODULES,
        'base_template': 'base.html' if request.user.is_superuser else 'base-public.html'
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))
