from django.conf.urls import url

from webtools import views, public_views
from webtools.disk import views as disk_views
from webtools.disk import staff_views as disk_staff_views
from webtools.aceventura import views as aceventura_views
from webtools.messenger import views as messenger_views
from webtools.so_fraud.views import NewListView, ListsSearchView, TransactionsSearchView, TransactionView

urlpatterns = [
    #disk
    # for backward compatibility
    url(r'disk/reindex$', disk_views.reindex_template, name='disk.search.reindex', kwargs={'project': 'disk_search_prod'}),
    url(r'^dashboard', views.dashboard, name='old.dashboard', kwargs={'project': 'all'}),
    #
    url(r'so_fraud_proxy/.*', views.so_fraud_proxy, name='common.so_fraud_proxy'),
    url(r'proxy/.*', views.proxy, name='common.proxy'),
    url(r'(?P<project>\w+)/health/info$', views.health_info, name='common.lucene.health'),
    url(r'(?P<project>\w+)/health/drop/info$', views.lucene_drop_info, name='common.lucene.health.drop.page'),
    url(r'(?P<project>\w+)/health/drop/shard/api$', views.lucene_drop_call, name='common.lucene.health.drop.api'),
    url(r'(?P<project>\w+)/queue/get$', views.common_queue_get, name='common.queue.get'),
    url(r'(?P<project>\w+)/backend/search$', views.backend_search, name='common.backend.search'),
    #disk
    url(r'(?P<project>\w+)/disk/search/reindex$', disk_views.reindex_template, name='disk.search.reindex'),
    url(r'(?P<project>\w+)/disk/search/api/reindex$', disk_views.api_reindex, name='disk.search.api.reindex'),
    url(r'(?P<project>\w+)/disk/search/api/ticket/reindex$', disk_views.api_reindex_from_ticket_start, name='disk.search.api.ticket.reindex'),
    url(r'(?P<project>\w+)/disk/support/ticket_created$', disk_views.support_ticket_created, name='disk.search.api.ticket.created'),
    url(r'(?P<project>\w+)/disk/api/reindex/completed$', disk_views.api_reindex_complete, name='disk.search.api.reindex.completed'),
    url(r'(?P<project>\w+)/disk/dashboard', disk_views.reindex_template, name='disk.dashboard'),
    url(r'(?P<project>\w+)/disk/video/beauty/result$', disk_views.video_beauty_result, name='disk.video_beauty_result'),
    url(r'(?P<project>\w+)/disk/video/beauty/list$', disk_views.video_beauty_list, name='disk.video.beauty.list'),
    url(r'(?P<project>\w+)/disk/video/beauty/video$', disk_views.get_video, name='disk.video.beauty.video'),
    url(r'(?P<project>\w+)/disk/resource/preview$', disk_views.get_preview, name='disk.preview'),
    url(r'(?P<project>\w+)/disk/resource/preview/public$', disk_views.get_preview_with_check, name='disk.preview.public'),
    url(r'(?P<project>\w+)/disk/faces/list$', disk_views.faces, name='disk.faces.list'),
    url(r'(?P<project>\w+)/disk/geo/list$', disk_views.geo_list, name='disk.geo.list'),
    url(r'disk/search/info/queue$', disk_staff_views.disk_search_queue, name='disk.search.queue'),
    url(r'disk/search/info$', disk_staff_views.disk_search_info, name='disk.search.info'),
    url(r'disk/search$', public_views.disk_search, name='disk.search.sbs'),
    #messenger
    url(r'(?P<project>\w+)/messenger/suggest/api$', messenger_views.suggest_api, name='messenger.suggest.api'),
    url(r'(?P<project>\w+)/messenger/suggest$', messenger_views.suggest_template, name='messenger.suggest.template'),
    url(r'(?P<project>\w+)/messenger/recommended_users$', messenger_views.recommended_users_template, name='messenger.recommended_users.api'),

    #aceventura
    url(r'(?P<project>\w+)/aceventura/suggest/api$', aceventura_views.suggest_api, name='aceventura.suggest.api'),
    url(r'(?P<project>\w+)/aceventura/suggest$', aceventura_views.suggest_template, name='aceventura.suggest.template'),
    url(r'(?P<project>\w+)/aceventura/check_index$', aceventura_views.check_index, name='aceventura.check_index.template'),

    url(r'iex/snippet$', public_views.iex_snippet, name='iex.snippet'),
    url(r'lucene/update_position', views.update_lucene_position, name='lucene.update.position'),
    url(r'api/iex/images', public_views.iex_images, name='api.iex.images'),
    url(r'iex/images', public_views.iex_images_template, name='iex.images.template'),
    url(r'mail/search/snippet$', public_views.mail_search_snippet, name='mail_search_snippet'),
    url(r'mail/search/proxy$', public_views.mail_search_proxy, name='mail_search_proxy'),
    url(r'(?P<project>\w+)/mail/search/check/index$', views.mail_search_index_check, name='mail.search.index_check'),
    url(r'(?P<project>\w+)/mail/iex/facts$', views.mail_iex_facts, name='mail.iex.facts'),
    url(r'(?P<project>\w+)/iex/remorph$', views.mail_iex_remorph, name='mail.iex.remorph'),
    url(r'(?P<project>\w+)/mail/search/info/lucene$', views.mail_search_lucene, name='mail_search_lucene'),
    url(r'(?P<project>\w+)/mail/search/info$', views.mail_search_info, name='mail.search.info'),
    url(r'(?P<project>\w+)/mail/search/reindex', views.mail_search_reindex, name='mail.search.reindex'),
    url(r'(?P<project>\w+)/mail/search/api/reindex', views.do_mail_search_reindex, name='mail.search.reindex.api'),
    url(r'(?P<project>\w+)/mail/search$', public_views.mail_search, name='mail.mail_search'),
    url(r'(?P<project>\w+)/so_fraud/log/tail$', views.so_fraud_log_tail, name='so_fraud.log.tail'),

    url(r'(?P<project>\w+)/so_fraud/create_list', NewListView.as_view(), name='so_fraud.create_list'),
    url(r'(?P<project>\w+)/so_fraud/lists_search', ListsSearchView.as_view(), name='so_fraud.lists_search'),

    url(r'(?P<project>\w+)/so_fraud/transactions_search', TransactionsSearchView.as_view(), name='so_fraud.transactions_search'),
    url(r'(?P<project>\w+)/so_fraud/transaction_view', TransactionView.as_view(), name='so_fraud.transaction_view'),

    url(r'lucene/copy_shard$', views.copy_shard, name='lucene.copy_shard'),
    url(r'common/user/register', views.register_user, name='common.user.register'),
    url(r'lucene/api/copy_job/create$', views.create_copy_job, name='create_copy_job'),
    url(r'lucene/copy_jobs$', views.copy_jobs_list, name='copy_jobs_list'),
    url(r'lucene/api/copy_job/list', views.api_job_list, name='api_job_list'),

    url(r'(?P<project>\w+)/mail/search/filter/search$', views.mail_search_filter_search, name='mail.search.filter.search'),
    url(r'(?P<project>\w+)/heatmap/(?P<service>\w+)$', views.shards_heatmap, name='common.heatmap'),
    url(r'(?P<project>\w+)/dashboard', views.dashboard, name='common.dashboard'),
    url(r'home$', views.dashboard, name='home', kwargs={'project': 'all'}),
]
