# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import json
import logging
import re
import time
import urllib
from collections import OrderedDict

import datetime
import urlparse
from wsgiref.util import is_hop_by_hop

import pytz
import requests
from django.conf import settings
from django.contrib.admin.views.decorators import staff_member_required
from django.contrib.auth.mixins import UserPassesTestMixin, LoginRequiredMixin
from django.contrib.auth.models import Group, User
from django.contrib.staticfiles.templatetags.staticfiles import static

from django.contrib.auth.decorators import login_required, permission_required, user_passes_test
from django.core.exceptions import PermissionDenied

from django.http import HttpResponse, HttpResponseServerError, HttpResponseRedirect
from django.shortcuts import render
from django.template import loader

# Create your views here.

from mail_search_webtools.settings import WEBTOOLS_API_HOST, WEBTOOLS_MODULES, HEATMAP_FILE_PATTERN, \
    WEBTOOLS_MODULES_GROUPS, SO_FRAUD_PROXY_HOST, SO_FRAUD_BACKEND_HOST
from webtools.disk.staff_views import copy_options, get_user_channels_map
from webtools.models import LinkedYandexUser, UserReindexation, ManualCopyJob, COPY_JOB_STATUSES, \
    LuceneDropShard
from webtools.so_fraud.forms import NewListForm, ListsRequestForm
from webtools.so_fraud.views import StaffMemberFormView
from webtools.views_utils import load_projects, load_queues, default_context

log = logging.getLogger('views')

DEFAULT_OPTIONS = OrderedDict()
DEFAULT_OPTIONS['lucene'] = {'id': 'luceneCbx', 'label': 'Люцена', 'param': 'lucene', 'checked': False}
DEFAULT_OPTIONS['allbackends'] = {'id': 'allbackendsCbx', 'label': 'Все бекенды', 'param': 'lucene-allbackends', 'checked': False}
DEFAULT_OPTIONS['facts'] = {'id': 'factsCbx', 'label': 'Факты', 'param': 'facts', 'checked': False}
DEFAULT_OPTIONS['queue'] = {'id': 'queueCbx', 'label': 'Queue', 'param': 'queue', 'checked': False}
DEFAULT_OPTIONS['filterSearch'] = {'id': 'filterSearchCbx', 'label': 'FilterSearch', 'param': 'filterSearch', 'checked': False}

def user_in_group(user, group):
    return user.groups.filter(name=group).exists()

def check_user_mail_manager(user):
    manager_status = user.is_active and (user.is_superuser or user_in_group(user, 'mail_manager'))
    print 'Manager status', manager_status, user
    return user.is_active and (user.is_superuser or user_in_group(user, 'mail_manager'))

def proxy_host_request(request, host, remove_part, timeout=-1):
    get_params = request.GET.urlencode()
    if get_params:
        get_params = "?" + get_params
    path = host + request.path[len(remove_part):] + get_params
    print 'Getting proxy path', path
    if request.method == 'GET':
        if timeout > 0:
            resp = requests.get(path, timeout=60)
        else:
            resp = requests.get(path)
    elif request.method == 'POST':
        resp = requests.post(path, request.body)

    response = HttpResponse(status=resp.status_code, content=resp.content)
    for name, value in resp.headers.iteritems():
        if not is_hop_by_hop(name):
            response[name] = value

    return response

@login_required
def proxy(request):
    path = WEBTOOLS_API_HOST + request.path[len("/ui/proxy"):] + '?' + request.GET.urlencode()
    print 'Getting proxy path', path
    if request.method == 'GET':
        resp = requests.get(path, timeout=60)
    elif request.method == 'POST':
        resp = requests.post(path, request.body)

    response = HttpResponse(status=resp.status_code, content=resp.content)
    for name, value in resp.headers.iteritems():
        if not is_hop_by_hop(name):
            response[name] = value

    return response

@login_required
def so_fraud_proxy(request):
    path = SO_FRAUD_PROXY_HOST + request.path[len("/ui/so_fraud_proxy"):] + '?' + request.GET.urlencode()
    print 'Getting proxy path', path
    if request.method == 'GET':
        resp = requests.get(path, timeout=60)
    elif request.method == 'POST':
        resp = requests.post(path, request.body)

    response = HttpResponse(status=resp.status_code, content=resp.content)
    for name, value in resp.headers.iteritems():
        if not is_hop_by_hop(name):
            response[name] = value

    return response

@staff_member_required
def home(request):
    template = loader.get_template('base.html')

    context = {
        'user': request.user,
        'modules': WEBTOOLS_MODULES,
        'queue_names': load_projects(),
    }

    return HttpResponse(template.render(context, request))


@user_passes_test(check_user_mail_manager)
def mail_search_index_check(request, project):
    template = loader.get_template('mail/mail_search_index_check.html')

    options = OrderedDict()
    options['total'] = {'id': 'totalOption', 'label': 'Общее', 'param': 'total', 'checked': True}
    options['per-folder'] = {'id': 'perFolderOption', 'label': 'По Папкам', 'param': 'per-folder', 'checked': False}
    options['total-slow'] = {'id': 'totalSlowOption', 'label': 'Тело/Аттачи', 'param': 'total-slow', 'checked': False}
    options['peach'] = {'id': 'peachOption', 'label': 'Очередь Пич', 'param': 'peach', 'checked': False}

    for option in options.keys():
        if request.GET.get(option, ''):
            options[option]['checked'] = True

    context = {
        'options': options.values(),
        'request_text': request.GET.get('request_text', ''),
        'options_js': json.dumps(options.values()),
    }

    context.update(default_context(request, project))
    return HttpResponse(template.render(context, request))


@staff_member_required
def mail_search_info(request, project):
    template = loader.get_template('mail/mail_search_info.html')

    options = copy_options()
    for k,v in options.iteritems():
        v['checked'] = True

    context = {
        'options': options.values(),
        'collapsed': True,
        'request_text': request.GET.get('request_text', ''),
        'options_js': json.dumps(options.values()),
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


@staff_member_required
def so_fraud_log_tail(request, project):
    template = loader.get_template('so_fraud/log_tail.html')

    channels = get_user_channels_map(request.user)

    options = copy_options()
    for k,v in options.iteritems():
        v['checked'] = True

    context = {
        'options': options.values(),
        'collapsed': True,
        'request_text': request.GET.get('request_text', ''),
        'limit': request.GET.get('limit', '100'),
        'channel': request.GET.get('channel', 'acquiring'),
        'subChannel': request.GET.get('sub-channel', 'beru'),
        'options_js': json.dumps(options.values()),
        'channels_js': json.dumps(channels),
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


@staff_member_required
def mail_search_filter_search(request, project):
    template = loader.get_template('mail/mail_search_info.html')

    options = copy_options()
    options['filterSearch']['checked'] = True

    context = {
        'options': options.values(),
        'collapsed': False,
        'options_js': json.dumps(options.values()),
        'request_text': request.GET.get('request_text', ''),
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))

@staff_member_required
def common_queue_get(request, project):
    template = loader.get_template('common/queue.html')

    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError(project + ' not found')

    context = {
        'request_text': request.GET.get('request_text', ''),
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


@staff_member_required
def mail_iex_facts(request, project):
    template = loader.get_template('mail_search_info.html')

    options = copy_options()
    options['facts']['checked'] = True

    context = {
        'options': options.values(),
        'request_text': request.GET.get('request_text', ''),
        'collapsed': False,
        'options_js': json.dumps(options.values()),
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))

@staff_member_required
def health_info(request, project):
    template = loader.get_template('common/health.html')

    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError('Project not found ' + project)

    context = {
        'request_text': request.GET.get('request_text', ''),
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))

@staff_member_required
def lucene_drop_info(request, project):
    template = loader.get_template('common/shard_info.html')

    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError('Project not found ' + project)
    drop_host = request.GET.get('drop_host', '')
    drop_shard = request.GET.get('drop_shard', 'Host')
    dropping_host = drop_shard is None or drop_shard == 'Host'

    drop_history = []
    if not dropping_host:
        drop_shard = int(drop_shard.strip())
        drop_history = LuceneDropShard.objects.filter(component=project, host=drop_host, shard=drop_shard).order_by('-drop_date')[:30]
    else:
        drop_shard = 'Host'

    if len(drop_history) <= 0:
        drop_history = LuceneDropShard.objects.filter(component=project, host=drop_host).order_by('-drop_date')[:30]


    context = {
        'drop_host': drop_host,
        'drop_shard': drop_shard,
        'dropping_host': dropping_host,
        'drop_history': drop_history
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))

@staff_member_required
def lucene_drop_call(request, project):
    drop_host = request.GET.get('host', '')
    drop_shard = request.GET.get('shard', None)
    drop_policy = request.GET.get('drop_policy', 'recopy_over')
    if not drop_host:
        return HttpResponseServerError('Drop host not specified')

    if drop_shard is not None and drop_shard != 'Host' and not drop_shard.isdigit():
        return HttpResponseServerError('Drop shard is not valid')

    if drop_shard is None or drop_shard == 'Host':
        base_uri = WEBTOOLS_API_HOST + '/' + project + '/health/host/drop?&host=' + drop_host
        drop_shard = -1
    else:
        base_uri = WEBTOOLS_API_HOST + '/' + project + '/health/shard/drop?&host=' + drop_host
        base_uri += '&shard=' + drop_shard + '&drop_policy=' + drop_policy

    dropFlag = request.GET.get('drop', 'false')
    if dropFlag == 'true':
        if drop_host:
            dsh = LuceneDropShard()
            dsh.component = project
            dsh.host = drop_host
            dsh.shard = drop_shard
            dsh.user = request.user
            dsh.drop_date = datetime.datetime.now()
            dsh.save()

            resp = requests.get(base_uri + "&drop=true", timeout=80)
            status_code = resp.status_code
            if status_code == 200:
                data = resp.json()
                dsh.status = data.get('status', 'ERROR')
                dsh.lucene_shard = data.get('lucene_shard', -1)
                dsh.save()
            else:
                # non retriable
                status_code = 400

            return HttpResponse(status=status_code, content=resp.content)
        else:
            return HttpResponseServerError('Drop shard or drop host not specified')

    resp = requests.get(base_uri, timeout=20)

    return HttpResponse(status=resp.status_code, content=resp.content)

@staff_member_required
def mail_search_lucene(request, project):
    template = loader.get_template('common/backend_search.html')

    options = copy_options()
    options['lucene']['checked'] = True
    options['allbackends']['checked'] = True

    context = {
        'user': request.user,
        'options': options.values(),
        'collapsed': False,
        'request_text': request.GET.get('request_text', ''),
        'options_js': json.dumps(options.values()),
        'modules': WEBTOOLS_MODULES
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


@staff_member_required
def backend_search(request, project):
    template = loader.get_template('common/backend_search.html')
    linked = LinkedYandexUser.objects.filter(user=request.user).all()
    #
    if request.user.is_superuser:
        linked_count = len(linked)
        if linked_count > 0:
            linked = linked[linked_count - 1].uid
        else:
            linked = ''

    request_text_default = '&text='
    enviroment_default = '&get=*&prefix=' + unicode(linked)
    request_text = request.GET.get('request_text', '')
    # if request_text:
    #     qs_str = urllib.unquote(request_text)
    #     qs = urlparse.parse_qs(qs_str)
    #     if qs.get('text'):
    #         request_text_default += qs['text'][0]
    #         del qs['text']
    #
    #     enviroment_default = ''
    #     for k,v in qs.iteritems():
    #         enviroment_default += '&' + k + '=' + v[0]

    context = {
        'user': request.user,
        'request_text_default':  request_text_default,
        'request_text': request_text,
        'enviroment_default': enviroment_default,
        'modules': WEBTOOLS_MODULES
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


@staff_member_required
def mail_search_reindex(request, project):
    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError("Project not found " + project)

    template = loader.get_template('mail/reindex.html')

    offset = request.GET.get('offset', 0)
    limit = request.GET.get('limit', 40)
    reindexations = UserReindexation.objects.filter(component=project).order_by('-reindex_date_start')[offset:limit]

    context = {
        'history': reindexations
    }

    context.update(default_context(request, project))

    return HttpResponse(template.render(context, request))


@staff_member_required
def do_mail_search_reindex(request, project):
    if project not in WEBTOOLS_MODULES:
        return HttpResponseServerError('Project not found ' + project)

    uid = request.GET.get('uid')
    if not uid:
        return HttpResponse(status=400, content='Bad uid ' + uid)

    ur = UserReindexation()
    ur.uid = uid
    ur.component = project
    ur.user = request.user
    ur.reindex_date_start = datetime.datetime.now(tz=pytz.timezone('Europe/Moscow'))
    ur.reindex_date = datetime.datetime.now(tz=pytz.timezone('Europe/Moscow'))
    ur.save()

    path = WEBTOOLS_API_HOST + '/' + project + '/reindex?uid=' + uid

    resp = requests.get(path, timeout=60)
    if resp.status_code != 200:
        return HttpResponse(status=resp.status_code, content=resp.content)

    if resp.status_code != 200:
        ur.delete()
        return HttpResponse(status=resp.status_code, content=resp.content)

    ur.status = 'STARTED'

    ur.save()

    response_data = {'uid': uid, 'request-id': ur.id}
    return HttpResponse(status=200, content=json.dumps(response_data))

@staff_member_required
def register_user(request):
    template = loader.get_template('register_user.html')

    context = default_context(request, None)
    context['roles'] = list(Group.objects.all())
    context['roles'].append({'name': 'admin'})
    login = request.GET.get('login', '')
    context['login'] = login
    role = request.GET.get('role', '')

    result = None
    group = None
    role_applier = None

    if role:
        if role == 'admin':
            def apply_admin(user):
                user.is_superuser = True
                user.is_staff = True

            role_applier = apply_admin
        else:
            group = Group.objects.filter(name=role)
            if not group.exists():
                context['result'] = 'Group not found'
                return HttpResponse(template.render(context, request))

            role_applier = lambda x: x.groups.add(group.first().id)

    if login and role_applier is not None:
        api_resp = requests.get(
            WEBTOOLS_API_HOST + '/yandex/user/accounts?login=' + login,
            timeout=30)
        if api_resp.status_code != 200:
            context['result'] = 'Failed to resolve linked accounts ' + api_resp.status_code + ' ' + api_resp.content
            return HttpResponse(template.render(context, request))

        user, created = User.objects.get_or_create(
            username=login,
            email=login + '@yandex-team.ru')

        accounts_added = []
        already_existed = []
        for account in api_resp.json():
            if LinkedYandexUser.objects.filter(uid=account['uid']).exists():
                already_existed.append(unicode(account['login']))
                continue

            linked_user = LinkedYandexUser(
                user=user,
                uid=account['uid'],
                login=account['login'],
                email=account['login'] + '@yandex.ru')
            linked_user.save()
            accounts_added.append(unicode(account['login']))

        user.is_active = True
        role_applier(user)
        user.save()

        context['result'] = 'User created: ' + str(created) + ' linked added:' + ','.join(accounts_added) + " already: " + ','.join(already_existed)
    return HttpResponse(template.render(context, request))


@staff_member_required
def dashboard(request, project):
    template = loader.get_template('dashboard.html')

    context = default_context(request, project)

    return HttpResponse(template.render(context, request))


@staff_member_required
def mail_iex_remorph(request, project):
    template = loader.get_template('iex_remorph.html')

    context = default_context(request, project)

    return HttpResponse(template.render(context, request))


@staff_member_required
def copy_shard(request):
    template = loader.get_template('copy_shard.html')

    context = {
        'user': request.user,
        'modules': WEBTOOLS_MODULES
    }

    return HttpResponse(template.render(context, request))


def fastbone_host(host):
    if '.mail.yandex' in host or '.disk.yandex' in host:
        sep = str(host).index('.')
        return "fbs-"+ host[1:sep - 1] + ".mail.yandex.net"
    if 'yandex' in host:
        return "fb-" + host

    return host


@staff_member_required
def update_lucene_position(request):
    template = loader.get_template('update_lucene_position.html')

    context = {
        'user': request.user,
        'modules': WEBTOOLS_MODULES
    }

    return HttpResponse(template.render(context, request))


@staff_member_required
def copy_jobs_list(request):
    host = request.GET['hostname']
    port = request.GET['base_port']

    template = loader.get_template('copy_job_list.html')

    context = {
        'user': request.user,
        'base_port': port,
        'hostname': host,
        'modules': WEBTOOLS_MODULES
    }

    return HttpResponse(template.render(context, request))


@staff_member_required
def api_job_list(request):
    host = request.GET['host']
    port = request.GET['port']
    resp = requests.get('http://' + host + ':' + str(port) + '/?listjobs&json=true')
    if resp.status_code != 200:
        return HttpResponse(status=resp.status_code, content=resp.content)

    jobs = []
    for job_json_str in resp.content.split('\n'):
        if not job_json_str:
            continue

        job_item = json.loads(job_json_str)
        statuses = job_item['shards_status']
        total = len(statuses)
        finished_cnt = 0
        pending_cnt = 0
        for status in statuses:
            if 'FINISHED' == status:
                finished_cnt += 1
            elif 'PENDING' == status:
                pending_cnt += 1

        job = {
            'shards': str(job_item['start_shard']) + '-' + str(job_item['end_shard']),
            'sources': job_item['copy_urls'],
            'pending': pending_cnt, 'total': total,
            'finished': finished_cnt}
        jobs.append(job)

    return HttpResponse(status=200, content=json.dumps(jobs))

@staff_member_required
def create_copy_job(request):
    data_dict = dict(request.GET)
    inum_hosts = data_dict.pop('inum-hosts')
    if not inum_hosts:
        return HttpResponse(500, content='No inum hosts supplied')

    inum_hosts = inum_hosts[0].split(',')
    print 'Inums', inum_hosts
    dest_host = data_dict.get('dest-host')[0]
    # find dest host in inum hosts
    found = None
    for host in inum_hosts:
        if dest_host in host:
            found = host
            break

    if not found:
        return HttpResponse(status=500, content='{dst} not in inum hosts {inum}'.format(dst=dest_host, inum=inum_hosts))

    inum_hosts.remove(found)
    copy_urls = []
    for host in inum_hosts:
        copy_urls.append(host)
        copy_urls.append(fastbone_host(host))

    copy_urls = ';'.join(copy_urls)

    model_dict = {}
    for k, v in data_dict.iteritems():
        if v:
            value = v[0]
            if value == u'false':
                value = False
            elif value == u'true':
                value = True
            model_dict[k.replace('-', '_')] = value

    base_port = model_dict.pop('base_port')
    model_dict['copy_urls'] = copy_urls
    data_dict['from'] = copy_urls
    del data_dict['dest-host']
    model_dict['status'] = 'CREATED'
    job = ManualCopyJob(**model_dict)
    data_dict['shards'] = str(job.start_shard) + '-' + str(job.end_shard)
    del data_dict['start-shard']
    del data_dict['end-shard']
    uri_base = 'http://' + dest_host + ':' + str(base_port) + '/?copyindex&'
    uri = uri_base + urllib.urlencode(data_dict)

    resp = requests.get(uri_base, data_dict)
    if resp.status_code != 200:
        job.status = 'CREATION_FAILED'
        job.user = request.user
        job.save()

        error_text = uri + '\n' + resp.content
        return HttpResponse(status=resp.status_code, content=error_text)

    print 'CopyIndex successfull'
    job.user = request.user
    job.save()

    resp = {
        'job_id': job.id,
        'shards': data_dict['shards'],
        'destination': dest_host,
        'list_link': '/ui/lucene/copy_jobs?hostname=' + dest_host + '&base_port=' + str(base_port),
        'admin_link': '/ui/admin/webtools/manualcopyjob/' + str(job.id)
    }

    return HttpResponse(status=200, content=json.dumps(resp))


def shards_heatmap(request, project, service):
    template = loader.get_template('common/shards_heatmap.html')

    context = {
        'user': request.user,
        'heatmap_image_url': static('heatmap/' + project + '/' + service + '.png'),
        'coords_url': static('heatmap/' + project + '/' + service + '_coords.json'),
    }

    return HttpResponse(template.render(context, request))
