import requests
from mail_search_webtools.settings import WEBTOOLS_API_HOST, WEBTOOLS_MODULES, HEATMAP_FILE_PATTERN, \
    WEBTOOLS_MODULES_GROUPS

def load_projects():
    get_services_url = WEBTOOLS_API_HOST + '/projects'
    resp = requests.get(get_services_url, timeout=10)
    services = []
    if resp.status_code == 200:
        for project in resp.json():
            services.append(unicode(project['id']))
    else:
        services.append("Unable to load projects")

    return services

def load_queues(project_id):
    get_services_url = WEBTOOLS_API_HOST + '/' + project_id + '/searchmap/services'
    resp = requests.get(get_services_url, timeout=10)
    services = []
    if resp.status_code == 200:
        for service in resp.json():
            services.append(unicode(service))
    else:
        services.append("FailedLoadServices")

    return services


def default_context(request, project):
    if project in WEBTOOLS_MODULES:
        webtools_project = WEBTOOLS_MODULES[project]
        webtools_project_id = project
        project_queues = load_queues(project)
    else:
        webtools_project_id = None
        webtools_project = None
        project_queues = []

    context = {
        'user': request.user,
        'webtools_projects': WEBTOOLS_MODULES_GROUPS,
        'webtools_project': webtools_project,
        'webtools_project_id': webtools_project_id,
        'project_queues': project_queues,
    }

    return context
