#!/bin/bash

if [ -z "$YC_SERVICE" ]; then
  export IFS=$'\n';
  for service in $(curl -s  'localhost:8081/search?prefix=0&db=malformed_search_docs&text=id:*&hr&get=*&length=10&group=yc_mf_service&merge_func=none&sort=yc_mf_message_transfer_ts' | jq -r -c  .hitsArray[]); do
    echo $service | jq .yc_mf_service;
    tsf=$(echo $service | jq -r .yc_mf_message_transfer_ts);
    date --date "@$((tsf / 1000))";
    echo $service | jq -r .yc_mf_message_parse_error;
    echo $service | jq -r .yc_mf_message_data;
  done
else
  YC_LENGTH=${YC_LENGTH:-1}
  hits=$(curl -s  "localhost:8081/search?prefix=0&db=malformed_search_docs&text=yc_mf_service:$YC_SERVICE&hr&get=*&length=$YC_LENGTH&sort=yc_mf_message_transfer_ts" | jq -r -c  .hitsArray[])
  export IFS=$'\n';
  for hit in $hits; do
    tsf=$(echo $service | jq -r .yc_mf_message_transfer_ts);
    date --date "@$((tsf / 1000))";
    echo $service | jq -r .yc_mf_message_parse_error;
    echo $service | jq -r .yc_mf_message_data;
  done
fi
