#!/bin/bash
set -exo pipefail
source classpath.sh


source classpath.sh
case "$TYPE" in
  docker)
    echo "Docker deployment detection. PWD: $(pwd), source config: $ENV/yc_search_indexer_config.sh"
    export SEARCHMAP_PATH="/usr/yc/search/$ENV/searchmap_yc.txt"
#    export IAM_SA_FILEPATH="/secrets/sa_consumer.json"
    touch $SEARCHMAP_PATH
    ;;
  *)
    export SEARCHMAP_PATH="/usr/yc/search/searchmap_yc.txt"
    touch $SEARCHMAP_PATH
    ;;
esac

export FULL_LOG_FILE="/var/log/yc/search/yc_search_backend/full.log"
export ACCESS_LOG_FILE="/var/log/yc/search/yc_search_backend/access.log"
export INDEX_ACCESS_LOG_FILE="/var/log/yc/search/yc_search_backend/index-access.log"
export INDEX_LOG_FILE="/var/log/yc/search/yc_search_backend/index.log"
export ERROR_LOG_FILE="/var/log/yc/search/yc_search_backend/index.err"
export CONSUMER_ACCESS_LOG="/var/log/yc/search/yc_search_backend/consumer-access.log"
export CONSUMER_FULL_LOG="/var/log/yc/search/yc_search_backend/consumer-full.log"
export YC_SEARCH_BASE_DIR="/usr/yc/search"
export YC_SEARCH_BACKEND_DIR="$YC_SEARCH_BASE_DIR/yc_search_backend"
export INDEX_PATH="/media/yc/search/backend/index/"

export SERVER_PORT=8080
export SERVER_HOST=$(hostname -f)
export INUM="1"

APP_ARGS="
-DINUM=$INUM
"

CORE_DIR="/coredumps"
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$YC_SEARCH_BACKEND_DIR

export CPU_CORES=6
export MEMORY_LIMIT=$((1024*1024*1024*6))

source yc_backend_gc_args.sh

export INDEX_THREADS=2
export MERGE_THREADS=1
export SEARCH_THREADS=$CPU_CORES
export SEARCH_THREADS=$((SEARCH_THREADS - INDEX_THREADS))
export SEARCH_THREADS=$((SEARCH_THREADS - MERGE_THREADS))
export LIMIT_SEARCH_REQUESTS=$((SEARCH_THREADS - 1))
export SEARCH_THREADS=$(( SEARCH_THREADS < 1 ? 2 : SEARCH_THREADS ))
export LIMIT_SEARCH_REQUESTS=$(( LIMIT_SEARCH_REQUESTS < 4 ? 10 : LIMIT_SEARCH_REQUESTS ))

exec $YC_SEARCH_BACKEND_DIR/jdk/bin/java \
    -Djava.library.path=$YC_SEARCH_BACKEND_DIR/yc_backend \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    ru.yandex.dispatcher.consumer.ConsumerServer -config yc_consumer.conf ";" \
    ru.yandex.msearch.Daemon -config yc_search_backend.conf
