#!/bin/bash
set -exo pipefail

source yc_backend_config.sh

STATUS_PORTS=(
# consumer
$((BSCONFIG_IPORT + 3))
)

PING_PORTS=(
$((BSCONFIG_IPORT + 1))
$((BSCONFIG_IPORT + 2))
$((BSCONFIG_IPORT + 3))
)

end_date=$(expr $(date +%s) + 3600)
while true
do
    if [ $(date +%s) -ge $end_date ]
    then
        >&2 echo Status script timed out
        exit 1
    fi

    # Fast check, just sleep on failure
    failed=0
    for ping_port in ${PING_PORTS[@]}
    do
        if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
        then
            >&2 echo "Port $ping_port /ping check failed"
            failed=1
            break
        fi
    done

    if [ $failed -eq 1 ]
    then
        sleep 1
        continue
    fi

    break
done

sleep 5
for status_port in ${STATUS_PORTS[@]}
do
    if ! PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
    then
        >&2 echo "Port $status_port /status second check failed"
        exit 1
    fi
done

failed=0
for ping_port in ${PING_PORTS[@]}
do
    if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
    then
        >&2 echo "Port $ping_port /ping second check failed"
        exit 1
    fi
done

exit 0
