#!/bin/bash
set -exo pipefail
source yc_backend_config.sh
source classpath.sh


./check_its_status.py || exit 1

portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

export FULL_LOG_FILE="/logs/lucene-full.log"
export ACCESS_LOG_FILE="/logs/lucene-access.log"
export INDEX_ACCESS_LOG_FILE="/logs/index-access.log"
export INDEX_LOG_FILE="/logs/lucene-index.log"
export ERROR_LOG_FILE="/logs/lucene-error.log"
export CONSUMER_ACCESS_LOG="/logs/consumer-access.log"
export CONSUMER_FULL_LOG="/logs/consumer-full.log"

export SERVER_PORT=$BSCONFIG_IPORT
APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
-DINUM=$INUM
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR

source yc_backend_gc_args.sh

CPU_CORES_CORRECTION=${CPU_CORES_CORRECTION:-"0.2"}
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi

export INDEX_THREADS=2
export MERGE_THREADS=1
export SEARCH_THREADS=$CPU_CORES
export SEARCH_THREADS=$((SEARCH_THREADS - INDEX_THREADS))
export SEARCH_THREADS=$((SEARCH_THREADS - MERGE_THREADS))
export LIMIT_SEARCH_REQUESTS=$((SEARCH_THREADS - 1))
export SEARCH_THREADS=$(( SEARCH_THREADS < 1 ? 2 : SEARCH_THREADS ))
export LIMIT_SEARCH_REQUESTS=$(( LIMIT_SEARCH_REQUESTS < 1 ? 10 : LIMIT_SEARCH_REQUESTS ))
export SEARCHMAP_PATH=$BSCONFIG_IDIR/searchmap.txt

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=yc_backend \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    ru.yandex.dispatcher.consumer.ConsumerServer -config yc_consumer.conf ";" \
    ru.yandex.msearch.Daemon -config yc_search_backend.conf
