package ru.yandex.yc.search;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.Config;
import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.msearch.collector.docprocessor.AbstractJoinDocProcessor;
import ru.yandex.msearch.collector.docprocessor.ModuleFieldsAggregator;
import ru.yandex.search.yc.YcDocType;

public class YcMainDocJoiningDocProcessor extends AbstractJoinDocProcessor {
    private static final String LEFT_FIELD =
        StringHelper.intern(YcSearchFields.YC_MAIN_DOC_ID.prefixed());
    private static final String RIGHT_FIELD = StringHelper.intern("id");
    private static final String[] GET_FIELDS = new String[]{
        StringHelper.intern(YcSearchFields.YC_ATTRIBUTES.stored()),
        StringHelper.intern(YcSearchFields.YC_RESOURCE_PATH.stored())
    };

    private static final String[] LOAD_FIELDS = new String[]{
        LEFT_FIELD,
        Config.PREFIX_FIELD_KEY,
        StringHelper.intern(YcSearchFields.YC_DOC_TYPE.stored()),
        StringHelper.intern(YcSearchFields.YC_ATTRIBUTES.stored()),
        StringHelper.intern(YcSearchFields.YC_RESOURCE_PATH.stored())
    };
    private static final Set<String> LOAD_FIELDS_SET =
        Collections.unmodifiableSet(new LinkedHashSet<>(Arrays.asList(LOAD_FIELDS)));

    private final int docTypeIndex;
    private final int joinLeftFieldIndex;
    private final int[] getFieldsIndexes;
    private final MapFieldSelector fieldSelector;

    public YcMainDocJoiningDocProcessor(
        final String args,
        final ProcessorRequestContext context)
        throws ParseException {
        super(context);

        docTypeIndex = context.fieldToIndex().indexFor(StringHelper.intern(YcSearchFields.YC_DOC_TYPE.stored()));
        joinLeftFieldIndex = context.fieldToIndex().indexFor(LEFT_FIELD);
        this.fieldSelector = new MapFieldSelector(GET_FIELDS);
        getFieldsIndexes = new int[GET_FIELDS.length];
        for (int i = 0; i < GET_FIELDS.length; i++) {
            getFieldsIndexes[i] = context.fieldToIndex().indexFor(GET_FIELDS[i]);
        }
    }

    @Override
    public Set<String> loadFields() {
        return LOAD_FIELDS_SET;
    }

    @Override
    public boolean processWithFilter(final YaDoc3 doc) throws IOException {
        if (multiprefix) {
            if (!multiprefixSearcherUpdate(doc)) {
                return context.keepRightNull();
            }
        }

        YaField docTypeField = doc.getField(docTypeIndex);
        if (docTypeField != null) {
            if (YcDocType.FULL_DOC.fieldValue().equalsIgnoreCase(docTypeField.toString())) {
                return true;
            }
        }

        YaField field = doc.getField(joinLeftFieldIndex);
        if (field == null) {
            if (context.debug()) {
                context.ctx().logger().warning(
                    "Left Field not found in doc " + doc);
            }
            return context.keepRightNull();
        }

        String value = field.toString();
        Query joinQuery = buildJoinQuery(value, RIGHT_FIELD);
        Map<String, YaField> document = extractDoc(joinQuery, fieldSelector);
        if (document == EMPTY_DOC && !context.keepRightNull()) {
            return false;
        }

        for (int i = 0; i < GET_FIELDS.length; i++) {
            YaField sdata = document.get(GET_FIELDS[i]);

            if (sdata != null) {
                doc.setField(getFieldsIndexes[i], sdata);
            }
        }

        return true;
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(LOAD_FIELDS_SET, Collections.emptySet());
    }
}
