package ru.yandex.yc.search;

import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.msearch.collector.docprocessor.DefaultDocProcessorType;
import ru.yandex.msearch.collector.docprocessor.DocProcessor;
import ru.yandex.msearch.collector.docprocessor.DocProcessorFactory;
import ru.yandex.msearch.collector.docprocessor.DocProcessorType;

public class YcSearchDocProcessorFactory implements DocProcessorFactory {
    private final Map<String, DocProcessorType> dpMap;

    public YcSearchDocProcessorFactory() {
        Map<String, DocProcessorType> map = new LinkedHashMap<>();
        for (DefaultDocProcessorType dt : DefaultDocProcessorType.values()) {
            map.put(dt.name().toLowerCase(Locale.ENGLISH), dt);
        }

        for (DocProcessorType dt : YcSearchDocProcessorType.values()) {
            map.put(dt.name().toLowerCase(Locale.ENGLISH), dt);
        }

        this.dpMap = Collections.unmodifiableMap(map);
    }

    @Override
    public DocProcessor apply(
        final String value,
        final ProcessorRequestContext context)
        throws ParseException {
        int idx = value.indexOf('(');
        String name;
        String args;
        if (idx == -1) {
            name = value;
            args = null;
        } else {
            int lastPos = value.length() - 1;
            if (value.charAt(lastPos) != ')') {
                throw new ParseException(
                    "DocProcessor expected to be in form: name(args)", 0);
            }
            name = value.substring(0, idx);
            args = value.substring(idx + 1, lastPos);
        }

        DocProcessorType dpType = dpMap.get(name);
        if (dpType == null) {
            throw new ParseException(
                "Failed to parse function: " + value, 0);
        }

        return dpType.create(args, context);
    }
}

