#!/bin/bash
set -exo pipefail

export TVM_API_HOST=https://tvm-api.yandex.net

SERVICE_ENV=${NANNY_SERVICE_ID:-YC_INFRA}

if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1 + 0.2)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1 + 0.2)}')
fi

case "$NANNY_SERVICE_ID" in
    *_corp_prod)
        export TVM_CLIENT_ID=2016797
        export TVM_ALLOWED_SRCS="$TVM_CLIENT_ID"
        export YC_QUEUE=yc_change_log_corp_prod
        export PROXY_HOST=yc-search-proxy-corp.search.yandex.net
        #export PRODUCER_HOST=yc-search-producer-corp.search.yandex.net
        export PRODUCER_HOST=man1-5377-2b2-man-yacloud-sear-4ee-13726.gencfg-c.yandex.net
        export PRODUCER_SERVER_NAME=yc-search-producer-corp.search.yandex.net
        export PRODUCER_INDEXING_HOST=$PRODUCER_HOST
        export YC_PROXY_SERVER_NAME=yc-search-internal-prod.search.yandex.net
        export IAM_HOST="as.private-api.cloud.yandex.net:4286"
        ;;
    *_compute_preprod | *-compute-preprod)
        export TVM_CLIENT_ID=2017641
        export TVM_ALLOWED_SRCS="$TVM_CLIENT_ID"
        export YC_QUEUE=yc_change_log_compute_preprod
        export PROXY_HOST=yc-search-compute-preprod.n.yandex-team.ru
        #export PRODUCER_HOST=yc-search-producer-corp.search.yandex.net
        export PRODUCER_HOST=yc-search-producer-compute-preprod.n.yandex-team.ru
        export PRODUCER_SERVER_NAME=yc-search-producer-compute-preprod.n.yandex-team.ru
        export PRODUCER_INDEXING_HOST=$PRODUCER_HOST
        export YC_PROXY_SERVER_NAME=yc-search-compute-preprod.search.yandex.net
        export IAM_HOST="as.private-api.cloud-preprod.yandex.net:4286"
      ;;
    *_gpn_proxy_prod |*_compute_prod)
        export TVM_CLIENT_ID=2017643
        export TVM_ALLOWED_SRCS="$TVM_CLIENT_ID"
        export YC_QUEUE=yc_change_log_compute_prod
        export PROXY_HOST=yc-search-compute-prod.search.yandex.net
        export PRODUCER_HOST=yc-search-producer-compute-prod.n.yandex-team.ru
        export PRODUCER_SERVER_NAME=yc-search-producer-compute-prod.n.yandex-team.ru
        export PRODUCER_INDEXING_HOST=$PRODUCER_HOST
        export YC_PROXY_SERVER_NAME=$PROXY_HOST
        export IAM_HOST="as.private-api.cloud.yandex.net:4286"
      ;;
    *_test)
        export TVM_CLIENT_ID=2016037
        export TVM_ALLOWED_SRCS="$TVM_CLIENT_ID"
        export YC_QUEUE=yc_change_log_test
        export PROXY_HOST=yc-search-proxy-test.search.yandex.net
        export PRODUCER_HOST=yc-search-producer-test.n.yandex-team.ru
        export PRODUCER_SERVER_NAME=yc-search-producer-test.search.yandex.net
        export PRODUCER_INDEXING_HOST=$PRODUCER_HOST
        export IAM_HOST="as.private-api.cloud-testing.yandex.net:4286"
      ;;
esac

