package ru.yandex.search.yc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Common fields for each document
 */
public enum YcCommonFields {
    SERVICE(YcFields.SERVICE),
    NAME(YcFields.NAME),
    RESOURCE_ID(YcFields.RESOURCE_ID),
    RESOURCE_TYPE(YcFields.RESOURCE_TYPE),
    PERMISSION(YcFields.PERMISSION),
    FOLDER_ID(YcFields.FOLDER_ID),
    TIMESTAMP(YcFields.TIMESTAMP_STR),
    CLOUD_ID(YcFields.CLOUD_ID),
    ATTRIBUTES(YcFields.ATTRIBUTES);

    private static final Map<YcFields, YcCommonFields> FIELD_MAP;
    private static final Map<String, YcCommonFields> FIELDSTR_MAP;

    static {
        Map<YcFields, YcCommonFields> fieldMap = new LinkedHashMap<>();
        Map<String, YcCommonFields> fieldStrMap = new LinkedHashMap<>();

        for (YcCommonFields common: YcCommonFields.values()) {
            fieldMap.put(common.indexedField, common);
            fieldStrMap.put(common.indexedField.storeField(), common);
        }

        FIELD_MAP = Collections.unmodifiableMap(fieldMap);
        FIELDSTR_MAP = Collections.unmodifiableMap(fieldStrMap);
    }

    private final YcFields indexedField;
    private final String fieldName;

    YcCommonFields(final YcFields indexedField, final String name) {
        this.indexedField = indexedField;
        this.fieldName = name;
    }

    YcCommonFields(final YcFields indexedField) {
        this.indexedField = indexedField;
        this.fieldName = name().toLowerCase(Locale.ENGLISH);
    }

    public String fieldName() {
        return fieldName;
    }

    public static YcCommonFields convert(final YcFields field) {
        return FIELD_MAP.get(field);
    }

    public static YcCommonFields convert(final String field) {
        return FIELDSTR_MAP.get(field);
    }
}
