package ru.yandex.search.yc;

import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public interface YcDoc extends JsonValue {
    String service();

    String timestampStr();

    long timestampMicros();

    ZonedDateTime timestamp();

    default long reindexTimestampMicros() {
        if (reindexTimestamp() != null) {
            return ChronoUnit.MICROS.between(Instant.EPOCH, reindexTimestamp().toInstant());
        } else {
            return -1L;
        }
    }

    ZonedDateTime reindexTimestamp();

    String cloudId();

    String folderId();

    String permission();

    String resourceId();

    String resourceType();

    Map<String, JsonObject> attributes();

    boolean deleted();

    long deleteTsMicros();

    default void writeAttributeFields(final JsonWriterBase writer)
        throws IOException
    {
        writer.value(this);
    }

    default void writeMainFields(final JsonWriterBase writer)
        throws IOException
    {
        writer.value(this);
    }

    boolean reindex();
}
