package ru.yandex.search.yc;

import java.util.Locale;

public enum YcFields {
    ID("id"),
    MAIN_DOC_ID,
    NAME(true),
    DOC_TYPE(true),
    CLUSTER_ID,
    CLOUD_ID(true),
    RESOURCE_ID(true),
    RESOURCE_TYPE(true),
    SERVICE(true),
    FOLDER_ID(true),
    PERMISSION(true),
    RECORD_ID,
    ATTRIBUTE_NAME("yc_attname"),
    ATTRIBUTE_VALUE("yc_attvalue"),
    ATTRIBUTE_TYPE("yc_atttype"),
    ATTRIBUTES,
    TIMESTAMP_STR,
    TIMESTAMP(true),
    TRANSFER_TS,
    RESOURCE_PATH,
    DELETED_TIME(true);

    private final String fieldName;
    private final String prefixedName;
    private final boolean hasPrefixedAlias;

    YcFields(final boolean prefixAlias) {
        this(null, prefixAlias);
    }

    YcFields() {
        this(null);
    }

    YcFields(
        final String fieldName)
    {
        this(fieldName, false);
    }

    YcFields(
        final String fieldName,
        final boolean prefixAlias)
    {
        if (fieldName == null) {
            this.fieldName = "yc_" + name().toLowerCase(Locale.ENGLISH);
        } else {
            this.fieldName = fieldName;
        }

        this.hasPrefixedAlias = prefixAlias;

        if (prefixAlias) {
            this.prefixedName = this.fieldName + "_p";
        } else {
            this.prefixedName = this.fieldName;
        }
    }
    public String field() {
        return prefixedName;
    }

    public String prefixedField() {
        return prefixedName;
    }

    public boolean hasPrefixedAlias() {
        return hasPrefixedAlias;
    }

    public String globalField() {
        return fieldName;
    }

    public String storeField() {
        return globalField();
    }

    public static String resourceUrl(
        final String cloudId,
        final String service,
        final String resourceType,
        final String resourceId)
    {
        StringBuilder sb =
            new StringBuilder(
                cloudId.length()
                    + service.length()
                    + resourceType.length()
                    + resourceId.length() + 3);
        sb.append(cloudId);
        sb.append('_');
        sb.append(service);
        sb.append('_');
        sb.append(resourceType);
        sb.append('_');
        sb.append(resourceId);

        return sb.toString();
    }

    public static String mainDocId(
        final String cloudId,
        final String service,
        final String resourceType,
        final String resourceId)
    {
        StringBuilder sb =
            new StringBuilder(
                cloudId.length()
                    + service.length()
                    + resourceType.length()
                    + resourceId.length()
                    + 4);
        sb.append(cloudId);
        sb.append('_');
        sb.append(service);
        sb.append('_');
        sb.append(resourceType);
        sb.append('_');
        sb.append(resourceId);

        return sb.toString();
    }

    public static String mainDocId(final YcDoc doc) {
        return mainDocId(doc.cloudId(), doc.service(), doc.resourceType(), doc.resourceId());
    }

    public static String attributeDocId(final YcDoc doc, final String attName) {
        return attributeDocId(doc.cloudId(), doc.service(), doc.resourceType(), doc.resourceId(), attName);
    }

    public static String attributeDocId(
        final String cloudId,
        final String service,
        final String resourceType,
        final String resourceId,
        final String name)
    {
        StringBuilder sb =
            new StringBuilder(
                cloudId.length()
                    + service.length()
                    + resourceType.length()
                    + resourceId.length()
                    + name.length() + 4);
        sb.append(cloudId);
        sb.append('_');
        sb.append(service);
        sb.append('_');
        sb.append(resourceType);
        sb.append('_');
        sb.append(resourceId);
        sb.append('_');
        sb.append(name);

        return sb.toString();
    }

    public static String buildPrefix(final String cloudId) {
        return cloudId;
    }
}
