#!/bin/bash
set -exo pipefail

export YC_QUEUE=yc_change_log_compute_israel

export IAM_TOKEN_HOST="ts.private-api.yandexcloud.co.il:14282"
#export IAM_GATEWAY_HOST="iam.api.yandexcloud.co.il"
export IAM_GATEWAY_HOST="iam.api.cloudil.com"

export TOPICS=search-infrastructure,search-data-services,search-dev-services,search-cloud-native-services,search-access,search-s3,search-ymq,search-monitoring

export READ_ONLY_LOCAL=false
export SEND_BATCH_SIZE=1
export SERVICE_CONFIG=yc_logbroker.conf
export YC_PRODUCER_PORT=8080
export YC_INDEXER_PORT=8081
export YC_LOGBROKER_PORT=8082
export YC_INDEXER_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/index"
export YC_INDEXER_MARKETPLACE_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/marketplace/index"

export BALANCER_HOSTS="lb.tm7unn71h7i7cn31d.ydb.yandexcloud.co.il"
#export BALANCER_HOSTS="ydb-cp.private-api.yandexcloud.co.il"

export LOGBROKER_YDB_DATABASE="/israel_global/yc.search/4beesefe4ji24rbv2"

export LOGBROKER_YDB_ENDPOINT="lb.tm7unn71h7i7cn31d.ydb.yandexcloud.co.il:2135"
# export LOGBROKER_YDB_ENDPOINT="ydb-cp.private-api.yandexcloud.co.il:2135"

# Override options for marketplace logbroker consumer
export YC_MARKETPLACE_QUEUE="yc_change_log_marketplace_compute_israel"
export MARKETPLACE_SEND_BATCH_SIZE=1
export MARKETPLACE_TOPICS="marketplace-products"
export MARKETPLACE_CLIENT_ID="search-consumer-marketplace"
export YC_MARKETPLACE_LOGBROKER_PORT=8083

export BACKEND_HOST_TEMPLATE="backend"
export MARKET_BACKEND_HOST_TEMPLATE="mrkt-backend"
