#!/bin/bash
set -exo pipefail

export YC_QUEUE=yc_change_log_compute_preprod

export IAM_TOKEN_HOST="ts.private-api.cloud-preprod.yandex.net:4282"
export IAM_GATEWAY_HOST="iam.api.cloud-preprod.yandex.net"
export TOPICS=/yc.search/search-infrastructure,/yc.search/search-data-services,/yc.search/search-dev-services,/yc.search/search-cloud-native-services,/yc.search/search-access,/yc.search/search-s3,/yc.search/search-ymq,/yc.search/products,/yc.search/search-monitoring
export READ_ONLY_LOCAL=false
export SEND_BATCH_SIZE=1
export SERVICE_CONFIG=yc_logbroker.conf
export YC_PRODUCER_PORT=8080
export YC_INDEXER_PORT=8081
export YC_LOGBROKER_PORT=8082
export YC_INDEXER_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/index"
export YC_INDEXER_MARKETPLACE_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/marketplace/index"
export BALANCER_HOSTS="lb.cc8035oc71oh9um52mv3.ydb.mdb.cloud-preprod.yandex.net"
export LOGBROKER_YDB_DATABASE="/pre-prod_global/aoeb66ftj1tbt1b2eimn/cc8035oc71oh9um52mv3"
export LOGBROKER_YDB_ENDPOINT="lb.cc8035oc71oh9um52mv3.ydb.mdb.cloud-preprod.yandex.net:2135"

# Override options for marketplace logbroker consumer
export YC_MARKETPLACE_QUEUE="yc_change_log_marketplace_compute_preprod"
export MARKETPLACE_SEND_BATCH_SIZE=1
export MARKETPLACE_TOPICS="/yc.search/marketplace-products"
export MARKETPLACE_CLIENT_ID="/yc.search/search-consumer-marketplace"
export YC_MARKETPLACE_LOGBROKER_PORT=8083

export BACKEND_HOST_TEMPLATE="ycsearch-backend-preprod01"
export MARKET_BACKEND_HOST_TEMPLATE="ycsearch-mrkt-backend-preprod01"
