#!/bin/bash
set -exo pipefail

source classpath.sh
case "$TYPE" in
  docker)
    echo "Docker deployment detection. PWD: $(pwd), source config: $ENV/yc_search_indexer_config.sh"
    source $ENV/yc_search_indexer_config.sh
    export DC_ZONE=$ZONE
    export CLIENT_ID="search-consumer-$INDEX-$DC_ZONE"
    export INDEX_BACKEND_HOST="$BACKEND_HOST_TEMPLATE-$DC_ZONE-$INDEX.$(hostname -d):8082"
    export MARKET_INDEX_BACKEND_HOST="$MARKET_BACKEND_HOST_TEMPLATE-$DC_ZONE-$INDEX.$(hostname -d):8082"
    export SEARCHMAP_PATH="/usr/yc/search/$ENV/searchmap_yc.txt"
    export IAM_SA_FILEPATH="/secrets/sa_consumer.json"
    touch $SEARCHMAP_PATH
    ;;
  *)
    source yc_search_indexer_config.sh
    export DC_ZONE=$(hostname -s | grep -oE '\-rc1([a,b,c])')
    export CLIENT_ID="/yc.search/search-consumer-01$(echo $DC_ZONE | sed 's/rc1//g')"
    export INDEX_BACKEND_HOST="$BACKEND_HOST_TEMPLATE$DC_ZONE.$(hostname -d):8082"
    export MARKET_INDEX_BACKEND_HOST="$MARKET_BACKEND_HOST_TEMPLATE$DC_ZONE.$(hostname -d):8082"
    export SEARCHMAP_PATH="/usr/yc/search/searchmap_yc.txt"
    export IAM_SA_FILEPATH="/etc/sa_consumer.json"
    touch $SEARCHMAP_PATH

    ;;
esac

export LOGS_DIR="/var/log/yc/search/yc_search_indexer"
export YC_PROXY_CONFIG="yc_search_proxy_http.conf"
export INDEXER_FULL_LOG_FILE="$LOGS_DIR/full.log"
export INDEXER_ACCESS_LOG_FILE="$LOGS_DIR/access.log"
export LB_CONSUMER_ACCESS_LOG_FILE="$LOGS_DIR/consumer-access.log"
export LB_CONSUMER_FULL_LOG_FILE="$LOGS_DIR/consumer-full.log"

export LB_CONSUMER_MARKETPLACE_ACCESS_LOG_FILE="$LOGS_DIR/consumer-marketplace-access.log"
export LB_MARKET_MARKETPLACE_CONSUMER_FULL_LOG_FILE="$LOGS_DIR/consumer-marketplace-full.log"


export PRODUCER_ACCESS_LOG_FILE="$LOGS_DIR/producer_access.log"
export PRODUCER_FULL_LOG_FILE="$LOGS_DIR/producer_full.log"
export YC_SEARCH_BASE_DIR="/usr/yc/search"
export YC_INDEXER_WORK_DIR="$YC_SEARCH_BASE_DIR/yc_search_indexer"
export YC_PRODUCER_PORT=8080
export YC_INDEXER_PORT=8081
export YC_LOGBROKER_PORT=8082
export YC_INDEXER_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/index"
export YC_INDEXER_MARKETPLACE_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/marketplace/index"

export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

export CPU_CORES=5
export MEMORY_LIMIT=$((1024*1024*1024*6))

export PROXY_WORKERS=$((CPU_CORES / 2))
if [ "$PROXY_WORKERS" -lt 1 ]; then
    export PROXY_WORKERS=1
fi

XMX=$MEMORY_LIMIT
XMS=$((XMX / 4))

MEM_ARGS="-Xms${XMS} -Xmx${XMX}  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-XX:ActiveProcessorCount=${CPU_CORES} -Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/var/log/yc/search/yc_search_indexer/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

exec /usr/yc/search/yc_search_indexer/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=yc_indexer \
    -DYC_QUEUE=$YC_QUEUE \
    -DYC_MARKETPLACE_QUEUE=$YC_MARKETPLACE_QUEUE \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    ru.yandex.search.yc.YcIndexer yc_search_indexer.cloud.conf ";" \
    ru.yandex.logbroker2.Logbroker2Consumer yc_search_logbroker_consumer.cloud.conf ";" \
    ru.yandex.logbroker2.Logbroker2Consumer yc_search_logbroker_marketplace_consumer.cloud.conf ";" \
    ru.yandex.dispatcher.producer.Producer yc_search_producer.cloud.conf ";"

