source yc_config_base.sh

export BALANCER_HOSTS=logbroker.yandex.net

export GEO_DC=$(cat dump.json | jq -r .properties.BSCONFIG_ITAGS | egrep -o "a_geo_[a-z]+")
if [ "$GEO_DC" = "" ]
then
  export GEO_DC=$(cat dump.json | jq -r .properties.tags | egrep -o "a_geo_[a-z]+")
fi

if [ "$GEO_DC" = "a_geo_sas" ]
then
  export BALANCER_HOSTS=sas.logbroker.yandex.net
fi

if [ "$GEO_DC" = "a_geo_myt" ]
then
  export BALANCER_HOSTS=myt.logbroker.yandex.net
fi

if [ "$GEO_DC" = "a_geo_vla" ]
then
  export BALANCER_HOSTS=vla.logbroker.yandex.net
fi

if [ "$GEO_DC" = "a_geo_man" ]
then
  export BALANCER_HOSTS=iva.logbroker.yandex.net,man.logbroker.yandex.net
fi

case "$NANNY_SERVICE_ID" in
    *_test)
      export TOPICS=/mdb/porto/test/search-entities
      export CLIENT_ID=/mdb/search-entities-consumer
      export LOGROTATE_DAYS=5
      export INCOMING_DOCS_LOGROTATE_DAYS=365
      ;;
    *_corp_prod)
      export TOPICS=/mdb/porto/prod/search-entities
      export CLIENT_ID=/pssearch/prod/yc/corp/search-indexer
      export LOGROTATE_DAYS=15
      ;;
    *_compute_prod)
      export TOPICS=/yandexcloud/prod/search-infrastructure,/yandexcloud/prod/search-data-services,/yandexcloud/prod/search-dev-services,/yandexcloud/prod/search-cloud-native-services,/yandexcloud/prod/search-access,/yandexcloud/prod/search-s3,/yandexcloud/prod/search-ymq,/yc/marketplace/search/products
      export CLIENT_ID=/pssearch/prod/yc/compute/search-indexer
      export YC_CLOUD_PRODUCER_HOSTS="ycsearch-indexer-prod02-rc1a.yandexcloud.net:8081,ycsearch-indexer-prod02-rc1b.yandexcloud.net:8081,ycsearch-indexer-prod02-rc1c.yandexcloud.net:8081"
      export LOGROTATE_DAYS=15
      #export BALANCER_HOSTS=man.logbroker.yandex.net,vla.logbroker.yandex.net,sas.logbroker.yandex.net,myt.logbroker.yandex.net,iva.logbroker.yandex.net
      ;;
    *_compute_preprod | *-compute-preprod)
      export TOPICS=/yandexcloud/preprod/search-infrastructure,/yandexcloud/preprod/search-data-services,/yandexcloud/preprod/search-dev-services,/yandexcloud/preprod/search-cloud-native-services,/yandexcloud/preprod/search-access,/yandexcloud/preprod/search-s3,/yandexcloud/preprod/search-ymq,/yc-pre/marketplace/search/products
      export CLIENT_ID=/pssearch/preprod/yc/compute/search-indexer
      export YC_CLOUD_PRODUCER_HOSTS="ycsearch-indexer-preprod01-rc1a.cloud-preprod.yandex.net:8081,ycsearch-indexer-preprod01-rc1b.cloud-preprod.yandex.net:8081,ycsearch-indexer-preprod01-rc1c.cloud-preprod.yandex.net:8081"
      export LOGROTATE_DAYS=15
      #export BALANCER_HOSTS=man.logbroker.yandex.net,vla.logbroker.yandex.net,sas.logbroker.yandex.net,myt.logbroker.yandex.net,iva.logbroker.yandex.net
      ;;
esac

# logbroker cluster tvm id
export LB_TVM_CLIENT_ID=2001059

#export TOPICS=mdb--porto-test-search-entities
export READ_ONLY_LOCAL=true
export SEND_BATCH_SIZE=1
export SERVICE_CONFIG=yc_logbroker.conf
export SERVICE_PORT=$BSCONFIG_IPORT
export SRC_CLIENT_ID=$TVM_CLIENT_ID
export YC_PRODUCER_PORT=80
export YC_INDEXER_PORT=81
export YC_LOGBROKER_PORT=82
export YC_INDEXER_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/index"
export YC_INDEXER_MARKETPLACE_URI="http://localhost:${YC_INDEXER_PORT}/api/yc/marketplace/index"
