#!/bin/bash
set -exo pipefail

source yc_indexer_config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

XMX=$(portoctl get self memory_limit_total)
XMX=$(echo $XMX | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))

MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export PRINT_MARKETPLACE_DATA="true"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=yc_indexer \
    -DYC_QUEUE=$YC_QUEUE \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    ru.yandex.search.yc.YcIndexer yc_indexer.conf ";" \
    ru.yandex.dispatcher.producer.Producer yc_producer.conf ";" \
    ru.yandex.logbroker2.Logbroker2Consumer yc_logbroker_consumer.conf


