package ru.yandex.search.yc;

import java.io.IOException;
import java.util.Map;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriterBase;

public final class AttributeDoc implements SearchBackendDoc {
    private final YcDoc doc;
    private final String id;
    private final Map.Entry<String, JsonObject> attribute;

    public AttributeDoc(final YcDoc doc, final Map.Entry<String, JsonObject> attribute) {
        this.doc = doc;
        this.attribute = attribute;
        this.id = YcFields.attributeDocId(doc, attribute.getKey());
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();

        writer.key(YcFields.ID.storeField());
        writer.value(id);

        doc.writeAttributeFields(writer);

        writer.key(YcFields.MAIN_DOC_ID.storeField());
        writer.value(YcFields.mainDocId(doc));

        writer.key(YcFields.DOC_TYPE.storeField());
        writer.value(YcDocType.ATTRIBUTE_DOC.fieldValue());

        writer.key(YcFields.ATTRIBUTE_TYPE.storeField());
        writer.value(YcAttributeType.SIMPLE.fieldValue());

        writer.key(YcFields.ATTRIBUTE_NAME.storeField());
        writer.value(attribute.getKey());

        writer.key(YcFields.ATTRIBUTE_VALUE.storeField());

        try {
            switch (attribute.getValue().type()) {
                case LIST:
                    StringBuilder sb = new StringBuilder();
                    for (JsonObject item: attribute.getValue().asList()) {
                        sb.append(item.asString());
                        sb.append('\n');
                    }

                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }

                    writer.value(sb.toString());
                    break;
                case MAP:
                    throw new IOException(
                        "Unsupported map structure in attributes " + JsonType.NORMAL.toString(doc));
                default:
                    writer.value(attribute.getValue().asString());
            }
        } catch (JsonException je) {
            throw new IOException(
                "Bad attribute " + attribute.getKey() + " "
                    + JsonType.NORMAL.toString(attribute.getValue()), je);
        }


        writer.endObject();
    }
}
