package ru.yandex.search.yc;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

public class CommonIndexHandler implements ProxyRequestHandler {
    private final YcIndexer ycIndexer;

    private final YcSearchIndexer searchIndexer;
    private final YcMarketplaceIndexer marketplaceIndexer;

    public CommonIndexHandler(final YcIndexer ycIndexer) throws IOException {
        this.ycIndexer = ycIndexer;

        searchIndexer = new YcSearchIndexer(ycIndexer);
        marketplaceIndexer = new YcMarketplaceIndexer(ycIndexer);
    }

//    @Override
//    public HttpAsyncRequestConsumer<List<JsonMap>> processRequest(
//        final HttpRequest request,
//        final HttpContext context)
//        throws HttpException, IOException
//    {
//        if (!(request instanceof HttpEntityEnclosingRequest)) {
//            throw new BadRequestException("We accept post requests");
//        }
//
//        return new JsonStreamAsyncConsumer<>(
//            ((HttpEntityEnclosingRequest) request).getEntity(),
//            JsonObject::asMap,
//            ArrayList::new,
//            StringCollectorsFactory.INSTANCE,
//            BasicContainerFactory.INSTANCE);
//    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        String topic = session.params().getString("topic", "");
//        rt3.global--yc.search--search-dev-services = /yc.search/search-dev-services
//        global--yc.search--marketplace-products = /yc.search/marketplace-products
        if (topic.contains("yc.search--marketplace-products") || topic.contains("@marketplace@search--products") || topic.contains("@marketplace-products")) {
            marketplaceIndexer.handle(session);
        } else {
            searchIndexer.handle(session);
        }
    }
}
