package ru.yandex.search.yc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;
import ru.yandex.util.string.StringUtils;

public class FieldGroupingElementStater implements Stater {
    private static final String AMMM = "_ammm";

    private final Map<String, TimeFrameQueue<Long>> map;
    private final String signalPrefix;
    private final long metricsTimeFrame;

    public FieldGroupingElementStater(
        final long metricsTimeFrame,
        final String signalPrefix)
    {
        this.signalPrefix = signalPrefix;
        this.map = new ConcurrentHashMap<>();
        this.metricsTimeFrame = metricsTimeFrame;
    }

    public TimeFrameQueue<Long> getOrCreate(final String key) {
        return map.computeIfAbsent(key, (k) -> new TimeFrameQueue<>(metricsTimeFrame));
    }


    private <E extends Exception> void statForKey(
        final String name,
        final StatsConsumer<? extends E> statsConsumer,
        final TimeFrameQueue<Long> data)
        throws E
    {
        long result = 0;
        for (Long value: data) {
            result += value;
        }

        statsConsumer.stat(
            StringUtils.concat(
                signalPrefix,
                name,
                AMMM),
            result);
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        for (Map.Entry<String, TimeFrameQueue<Long>> entry: map.entrySet()) {
            statForKey(entry.getKey(), statsConsumer, entry.getValue());
        }
    }
}
