package ru.yandex.search.yc;

public enum IndexationTargetFactory {
    PRODUCER {
        @Override
        IndexationTarget create(final YcSearchIndexer indexer) {
            return new ProducerIndexationTarget(indexer);
        }
    },

    BACKEND {
        @Override
        IndexationTarget create(final YcSearchIndexer indexer) {
            return new BackendIndexationTarget(indexer.server().producerHost(), indexer);
        }
    };

    abstract IndexationTarget create(final YcSearchIndexer indexer);
}
