package ru.yandex.search.yc;

import java.io.IOException;
import java.util.Map;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriterBase;

final class LabelDoc implements SearchBackendDoc {
    private final YcDoc doc;
    private final String id;
    private final String attname;
    private final Map.Entry<String, JsonObject> labelEntry;

    public LabelDoc(final YcDoc doc, final Map.Entry<String, JsonObject> labelEntry) {
        this.doc = doc;
        this.labelEntry = labelEntry;
        this.attname = "label_" + labelEntry.getKey();
        this.id = YcFields.attributeDocId(doc, attname);
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key(YcFields.ID.storeField());
        writer.value(YcFields.attributeDocId(doc, attname));

        doc.writeAttributeFields(writer);

        writer.key(YcFields.MAIN_DOC_ID.storeField());
        writer.value(YcFields.mainDocId(doc));

        writer.key(YcFields.DOC_TYPE.storeField());
        writer.value(YcDocType.ATTRIBUTE_DOC.fieldValue());

        writer.key(YcFields.ATTRIBUTE_TYPE.storeField());
        writer.value(YcAttributeType.LABEL.fieldValue());

        writer.key(YcFields.ATTRIBUTE_NAME.storeField());
        writer.value(attname);
        writer.key(YcFields.ATTRIBUTE_VALUE.storeField());
        try {
            writer.value(labelEntry.getValue().asString());
        } catch (JsonException je) {
            throw new IOException("Bad label " + labelEntry.getKey() + " " + JsonType.NORMAL.toString(labelEntry.getValue()));
        }

        writer.endObject();
    }
}
