package ru.yandex.search.yc;

import java.io.IOException;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriterBase;

public final class MainDoc implements SearchBackendDoc {
    private final YcDoc doc;
    private final String id;

    public MainDoc(final YcDoc doc) {
        this.doc = doc;
        this.id = YcFields.mainDocId(doc);
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key(YcFields.ID.storeField());
        writer.value(id);
        writer.key(YcFields.ATTRIBUTES.storeField());
        writer.value(JsonType.NORMAL.toString(doc.attributes()));
        writer.key(YcFields.DOC_TYPE.storeField());
        writer.value(YcDocType.FULL_DOC.fieldValue());

        doc.writeMainFields(writer);

        writer.endObject();
    }
}
