package ru.yandex.search.yc;

import ru.yandex.client.producer.ProducerClient;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeLongValidator;
import ru.yandex.parser.uri.CgiParams;

public class YcSearchIndexRequestContext {
    private final ProxySession session;
    private final ProducerClient client;
    private final String topic;
    private final String partition;
    private final long offset;
    private final long seqNo;
    private final long messageCreateTime;
    private final long messageWriteTime;
    private final long transferTs;
    private final boolean logIncomingDoc;
    private final boolean logOutDoc;
    private final BadIndexMessageAction badIndexMessageAction;
    private final YcSearchIndexer indexer;

    public YcSearchIndexRequestContext(
        final YcSearchIndexer indexer,
        final ProxySession session)
        throws BadRequestException
    {
        this(indexer, session, session.params());
    }

    public YcSearchIndexRequestContext(
        final YcSearchIndexer indexer,
        final ProxySession session,
        final CgiParams params)
        throws BadRequestException
    {
        this.session = session;
        this.indexer = indexer;
        this.client = indexer.server().producerClient().adjust(session.context());
        this.topic = params.get("topic", NonEmptyValidator.TRIMMED);
        this.partition = params.getString("partition");
        this.offset = params.get("offset", NonNegativeLongValidator.INSTANCE);
        this.seqNo = params.get("seqNo", NonNegativeLongValidator.INSTANCE);
        this.messageCreateTime = params.get("message-create-time", NonNegativeLongValidator.INSTANCE);
        this.messageWriteTime = params.get("message-write-time", NonNegativeLongValidator.INSTANCE);
        this.transferTs = params.getLong("transfer_ts", System.currentTimeMillis());
        this.logIncomingDoc = params.getBoolean("log-incoming-doc", true);
        this.logOutDoc = params.getBoolean("log-out-doc", false);
        this.badIndexMessageAction =
            params.getEnum(
                BadIndexMessageAction.class,
                "parse-fail-action",
                indexer.server().config().badIndexMessageAction());
    }

    public ProxySession session() {
        return session;
    }

    public String topic() {
        return topic;
    }

    public String partition() {
        return partition;
    }

    public long offset() {
        return offset;
    }

    public long seqNo() {
        return seqNo;
    }

    public long messageCreateTime() {
        return messageCreateTime;
    }

    public long messageWriteTime() {
        return messageWriteTime;
    }

    public long transferTs() {
        return transferTs;
    }

    public ProducerClient client() {
        return client;
    }

    public BadIndexMessageAction badIndexMessageAction() {
        return badIndexMessageAction;
    }

    public boolean logIncomingDoc() {
        return logIncomingDoc;
    }

    public YcSearchIndexer indexer() {
        return indexer;
    }
}
