package ru.yandex.search.yc.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFieldGroupingElementStaterConfigBuilder
    <T extends AbstractFieldGroupingElementStaterConfigBuilder<T>>
     implements FieldGroupingElementStaterConfig
{
    private String query;
    private String signalName;

    public AbstractFieldGroupingElementStaterConfigBuilder(final FieldGroupingElementStaterConfig config) {
        query(config.query());
        signalName(config.signalName());
    }

    public AbstractFieldGroupingElementStaterConfigBuilder(
        final IniConfig config,
        final FieldGroupingElementStaterConfig defaults)
        throws ConfigException
    {
        this.query = config.getString("query", defaults.query());
        this.signalName = config.getString("signal-name", defaults.signalName());
    }

    @Override()
    public String query() {
        return query;
    }

    public T query(final String value) {
        this.query = value;
        return self();
    }

    public String signalName() {
        return signalName;
    }

    public void signalName(final String signalName) {
        this.signalName = signalName;
    }

    protected abstract T self();
}
