package ru.yandex.search.yc.config;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFieldGroupingElementStatersConfigBuilder
    <T extends AbstractFieldGroupingElementStatersConfigBuilder<T>>
     extends AbstractHttpHostConfigBuilder<T>
     implements FieldGroupingElementStatersConfig
{
    private Map<String, FieldGroupingElementStaterConfigBuilder> fieldGroupingElementStats;
    private StaleDocsConfigBuilder staleConfig;
    private int interval;

    public AbstractFieldGroupingElementStatersConfigBuilder(final FieldGroupingElementStatersConfig config) {
        super(config);
        fieldGroupingElementStats(config.fieldGroupingElementStats());
        interval(config.interval());
    }

    public AbstractFieldGroupingElementStatersConfigBuilder(
        final IniConfig config,
        final FieldGroupingElementStatersConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        IniConfig statSection = config.sectionOrNull("stat");
        Map<String, FieldGroupingElementStaterConfigBuilder> fieldGroupingElementStatMap = new LinkedHashMap<>();
        if (statSection != null) {
            for (Map.Entry<String, IniConfig> entry: statSection.sections().entrySet()) {
                fieldGroupingElementStatMap.put(entry.getKey(), new FieldGroupingElementStaterConfigBuilder(entry.getValue()));
            }
        }

        this.interval = config.getIntegerDuration("interval", defaults.interval());
        IniConfig staleSection = config.sectionOrNull("stale");
        if (staleSection != null) {
            staleConfig = new StaleDocsConfigBuilder(staleSection, defaults.staleConfig());
        } else {
            staleConfig = new StaleDocsConfigBuilder(defaults.staleConfig());
        }
        this.fieldGroupingElementStats = fieldGroupingElementStatMap;
    }

    @Override()
    public Map<String, ? extends FieldGroupingElementStaterConfig> fieldGroupingElementStats() {
        return fieldGroupingElementStats;
    }

    public T fieldGroupingElementStats(final Map<String, ? extends FieldGroupingElementStaterConfig> map) {
        this.fieldGroupingElementStats = new LinkedHashMap<>();
        for (Map.Entry<String, ? extends FieldGroupingElementStaterConfig> entry: map.entrySet()) {
            fieldGroupingElementStats.put(entry.getKey(), new FieldGroupingElementStaterConfigBuilder(entry.getValue()));
        }

        return self();
    }

    @Override()
    public int interval() {
        return interval;
    }

    public T interval(final int value) {
        this.interval = value;
        return self();
    }

    @Override
    public StaleDocsConfigBuilder staleConfig() {
        return staleConfig;
    }

    public T staleConfig(final StaleDocsConfig staleConfig) {
        this.staleConfig = new StaleDocsConfigBuilder(staleConfig);
        return self();
    }
}
